/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.internal.functions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.JsonNode;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.node.ArrayNode;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.node.JsonNodeType;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.Function;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.JsonQuery;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.Scope;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.exception.JsonQueryException;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.internal.BuiltinFunction;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.internal.misc.JsonNodeComparator;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.internal.misc.JsonNodeUtils;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.internal.misc.Pair;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.internal.misc.Preconditions;

@BuiltinFunction(value={"sort/1"})
public class SortFunction
implements Function {
    private static final JsonNodeComparator comparator = JsonNodeComparator.getInstance();

    @Override
    public List<JsonNode> apply(Scope scope, List<JsonQuery> args, JsonNode items) throws JsonQueryException {
        Preconditions.checkInputType("sort", items, JsonNodeType.ARRAY);
        ArrayList zipped = new ArrayList(items.size());
        for (JsonNode item : items) {
            ArrayNode value = JsonNodeUtils.asArrayNode(scope.getObjectMapper(), args.get(0).apply(scope, item));
            zipped.add(Pair.of(item, value));
        }
        Collections.sort(zipped, new Comparator<Pair<JsonNode, JsonNode>>(){

            @Override
            public int compare(Pair<JsonNode, JsonNode> o1, Pair<JsonNode, JsonNode> o2) {
                return comparator.compare((JsonNode)o1._2, (JsonNode)o2._2);
            }
        });
        return Collections.singletonList(JsonNodeUtils.asArrayNode(scope.getObjectMapper(), Pair._1(zipped)));
    }
}

