/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.internal.functions;

import java.util.ArrayList;
import java.util.List;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.JsonNode;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.node.JsonNodeType;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.node.TextNode;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.Function;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.JsonQuery;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.Scope;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.exception.JsonQueryException;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.internal.BuiltinFunction;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.internal.misc.Preconditions;

@BuiltinFunction(value={"rtrimstr/1"})
public class RTrimStrFunction
implements Function {
    @Override
    public List<JsonNode> apply(Scope scope, List<JsonQuery> args, JsonNode in) throws JsonQueryException {
        Preconditions.checkInputType("rtrimstr", in, JsonNodeType.STRING);
        String text = in.asText();
        ArrayList<JsonNode> out = new ArrayList<JsonNode>();
        for (JsonNode suffixNode : args.get(0).apply(scope, in)) {
            if (!suffixNode.isTextual()) {
                throw new JsonQueryException("1st argument to rtrimstr() must be string, got " + (Object)((Object)suffixNode.getNodeType()));
            }
            String suffix = suffixNode.asText();
            if (!text.endsWith(suffix)) {
                out.add(in);
                continue;
            }
            out.add(new TextNode(text.substring(0, text.length() - suffix.length())));
        }
        return out;
    }
}

