/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.internal.functions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.JsonNode;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.node.ArrayNode;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.node.JsonNodeType;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.Function;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.JsonQuery;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.Scope;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.exception.JsonQueryException;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.internal.BuiltinFunction;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.internal.misc.JsonNodeComparator;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.internal.misc.JsonNodeUtils;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.internal.misc.Preconditions;

@BuiltinFunction(value={"group/1"})
public class GroupFunction
implements Function {
    private static final JsonNodeComparator comparator = JsonNodeComparator.getInstance();

    @Override
    public List<JsonNode> apply(Scope scope, List<JsonQuery> args, JsonNode in) throws JsonQueryException {
        Preconditions.checkInputType("group", in, JsonNodeType.ARRAY);
        TreeMap<JsonNode, ArrayList<JsonNode>> result = new TreeMap<JsonNode, ArrayList<JsonNode>>(comparator);
        for (JsonNode i : in) {
            ArrayNode fx = JsonNodeUtils.asArrayNode(scope.getObjectMapper(), args.get(0).apply(scope, i));
            ArrayList<JsonNode> values = (ArrayList<JsonNode>)result.get(fx);
            if (values == null) {
                values = new ArrayList<JsonNode>();
                result.put(fx, values);
            }
            values.add(i);
        }
        ArrayList<JsonNode> groups = new ArrayList<JsonNode>(result.size());
        for (List values : result.values()) {
            groups.add(JsonNodeUtils.asArrayNode(scope.getObjectMapper(), values));
        }
        return Collections.singletonList(JsonNodeUtils.asArrayNode(scope.getObjectMapper(), groups));
    }
}

