/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.java.prometheus.metrics.agent.scraper;

import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeMBeanException;
import net.thisptr.java.prometheus.metrics.agent.jackson.JmxModule;
import net.thisptr.java.prometheus.metrics.agent.misc.AttributeNamePattern;
import net.thisptr.java.prometheus.metrics.agent.scraper.ScrapeOutput;
import net.thisptr.java.prometheus.metrics.agent.scraper.ScrapeRule;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.core.JsonProcessingException;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.JsonNode;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.MapperFeature;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.ObjectMapper;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.node.ObjectNode;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.node.TextNode;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.exception.JsonQueryException;

public class Scraper<ScrapeRuleType extends ScrapeRule> {
    private static final Logger LOG = Logger.getLogger(Scraper.class.getName());
    private final ObjectMapper jmxMapper = new ObjectMapper().registerModule(new JmxModule()).disable(MapperFeature.AUTO_DETECT_GETTERS).disable(MapperFeature.AUTO_DETECT_FIELDS).disable(MapperFeature.AUTO_DETECT_IS_GETTERS).disable(MapperFeature.AUTO_DETECT_SETTERS).disable(MapperFeature.AUTO_DETECT_CREATORS);
    private final List<ScrapeRuleType> rules;
    private final MBeanServer server;

    public Scraper(MBeanServer server, List<ScrapeRuleType> rules) {
        this.server = server;
        this.rules = rules;
    }

    private ScrapeRuleType findRule(ObjectName name, String attribute) {
        for (ScrapeRule rule : this.rules) {
            if (rule.patterns() == null || rule.patterns().isEmpty()) {
                return (ScrapeRuleType)rule;
            }
            for (AttributeNamePattern pattern : rule.patterns()) {
                if (!pattern.matches(name, attribute)) continue;
                return (ScrapeRuleType)rule;
            }
        }
        return null;
    }

    public void scrape(ScrapeOutput<ScrapeRuleType> output) throws IntrospectionException, InstanceNotFoundException, ReflectionException, IOException {
        for (ObjectInstance instance : this.server.queryMBeans(null, null)) {
            try {
                this.scrape(instance, output);
            }
            catch (Throwable th) {
                LOG.log(Level.FINE, "Failed to scrape MBean instance (" + instance.getObjectName() + ").", th);
            }
        }
    }

    public void scrape(ObjectInstance instance, ScrapeOutput<ScrapeRuleType> output) throws IntrospectionException, InstanceNotFoundException, ReflectionException {
        ObjectName name = instance.getObjectName();
        for (MBeanAttributeInfo attribute : this.server.getMBeanInfo(name).getAttributes()) {
            try {
                this.scrape(instance, attribute, output);
            }
            catch (Throwable th) {
                LOG.log(Level.FINER, "Failed to scrape MBean attribute (" + name + ":" + attribute.getName() + ").", th);
            }
        }
    }

    public void scrape(ObjectInstance instance, MBeanAttributeInfo attribute, ScrapeOutput<ScrapeRuleType> output) throws InstanceNotFoundException, AttributeNotFoundException, ReflectionException, MBeanException, JsonQueryException, JsonProcessingException, IOException {
        Object value;
        if (!attribute.isReadable()) {
            return;
        }
        ObjectName name = instance.getObjectName();
        ScrapeRuleType rule = this.findRule(name, attribute.getName());
        if (rule != null && rule.skip()) {
            return;
        }
        try {
            value = this.server.getAttribute(name, attribute.getName());
        }
        catch (RuntimeMBeanException e) {
            if (e.getCause() instanceof UnsupportedOperationException) {
                return;
            }
            throw e;
        }
        Object valueJson = this.jmxMapper.valueToTree(value);
        ObjectNode out = this.jmxMapper.createObjectNode();
        out.set("type", TextNode.valueOf(attribute.getType()));
        out.set("value", (JsonNode)valueJson);
        out.set("domain", TextNode.valueOf(name.getDomain()));
        ObjectNode properties = this.jmxMapper.createObjectNode();
        name.getKeyPropertyList().forEach((k, v) -> {
            if (v.startsWith("\"")) {
                v = ObjectName.unquote(v);
            }
            properties.set((String)k, TextNode.valueOf(v));
        });
        out.set("properties", properties);
        out.set("attribute", TextNode.valueOf(attribute.getName()));
        output.emit(rule, out);
    }
}

