/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.java.prometheus.metrics.agent;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.ReflectionException;
import net.thisptr.java.prometheus.metrics.agent.Config;
import net.thisptr.java.prometheus.metrics.agent.PrometheusMetric;
import net.thisptr.java.prometheus.metrics.agent.PrometheusMetricWriter;
import net.thisptr.java.prometheus.metrics.agent.PrometheusScrapeOutput;
import net.thisptr.java.prometheus.metrics.agent.RootScope;
import net.thisptr.java.prometheus.metrics.agent.scraper.Scraper;
import net.thisptr.java.prometheus.metrics.agent.shade.fi.iki.elonen.NanoHTTPD;

public class PrometheusExporterServer
extends NanoHTTPD {
    private static final Logger LOG = Logger.getLogger(PrometheusExporterServer.class.getName());
    private final Scraper<Config.PrometheusScrapeRule> scraper;

    public PrometheusExporterServer(Config config) {
        super(config.server.bindAddress.getHost(), config.server.bindAddress.getPortOrDefault(18090));
        this.scraper = new Scraper<Config.PrometheusScrapeRule>(ManagementFactory.getPlatformMBeanServer(), config.rules);
    }

    public NanoHTTPD.Response handleGetMetrics() throws IntrospectionException, InstanceNotFoundException, ReflectionException, IOException {
        TreeMap<String, List> allMetrics = new TreeMap<String, List>();
        this.scraper.scrape(new PrometheusScrapeOutput(RootScope.getInstance(), metric -> allMetrics.computeIfAbsent(metric.name, name -> new ArrayList()).add(metric)));
        StringWriter writer = new StringWriter();
        try (PrometheusMetricWriter pwriter = new PrometheusMetricWriter(writer);){
            allMetrics.forEach((name, metrics) -> metrics.forEach(metric -> {
                try {
                    pwriter.write((PrometheusMetric)metric);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }));
        }
        return PrometheusExporterServer.newFixedLengthResponse(NanoHTTPD.Response.Status.OK, "text/plain; version=0.0.4; charset=utf-8", writer.toString());
    }

    public NanoHTTPD.Response handleGetMBeans() throws IntrospectionException, InstanceNotFoundException, ReflectionException, IOException {
        StringWriter writer = new StringWriter();
        this.scraper.scrape((rule, value) -> {
            writer.write(value.toString());
            writer.write(10);
        });
        return PrometheusExporterServer.newFixedLengthResponse(NanoHTTPD.Response.Status.OK, "text/plain; charset=utf-8", writer.toString());
    }

    public NanoHTTPD.Response handleGetMetricsRaw() throws IntrospectionException, InstanceNotFoundException, ReflectionException, IOException {
        StringWriter writer = new StringWriter();
        this.scraper.scrape(new PrometheusScrapeOutput(RootScope.getInstance(), metric -> {}, raw -> {
            writer.write(raw.toString());
            writer.write(10);
        }));
        return PrometheusExporterServer.newFixedLengthResponse(NanoHTTPD.Response.Status.OK, "text/plain; charset=utf-8", writer.toString());
    }

    private NanoHTTPD.Response dispatch(NanoHTTPD.IHTTPSession session) {
        try {
            switch (session.getUri()) {
                case "/metrics": {
                    if (session.getMethod() != NanoHTTPD.Method.GET) {
                        return PrometheusExporterServer.handleMethodNotAllowed();
                    }
                    return this.handleGetMetrics();
                }
                case "/mbeans": {
                    if (session.getMethod() != NanoHTTPD.Method.GET) {
                        return PrometheusExporterServer.handleMethodNotAllowed();
                    }
                    return this.handleGetMBeans();
                }
                case "/metrics-raw": {
                    if (session.getMethod() != NanoHTTPD.Method.GET) {
                        return PrometheusExporterServer.handleMethodNotAllowed();
                    }
                    return this.handleGetMetricsRaw();
                }
            }
        }
        catch (Throwable th) {
            return PrometheusExporterServer.handleInternalError(th);
        }
        return PrometheusExporterServer.handleNotFound();
    }

    private static NanoHTTPD.Response handleMethodNotAllowed() {
        return PrometheusExporterServer.newFixedLengthResponse(NanoHTTPD.Response.Status.METHOD_NOT_ALLOWED, null, null);
    }

    private static NanoHTTPD.Response handleNotFound() {
        return PrometheusExporterServer.newFixedLengthResponse(NanoHTTPD.Response.Status.NOT_FOUND, null, null);
    }

    private static NanoHTTPD.Response handleInternalError(Throwable th) {
        StringWriter writer = new StringWriter();
        try (PrintWriter pwriter = new PrintWriter(writer);){
            th.printStackTrace(pwriter);
        }
        return PrometheusExporterServer.newFixedLengthResponse(NanoHTTPD.Response.Status.INTERNAL_ERROR, "text/plain", writer.toString());
    }

    @Override
    public NanoHTTPD.Response serve(NanoHTTPD.IHTTPSession session) {
        NanoHTTPD.Response response = this.dispatch(session);
        LOG.log(Level.FINE, session.getRemoteIpAddress() + " " + (Object)((Object)session.getMethod()) + " " + session.getUri() + " " + response.getStatus().getRequestStatus());
        return response;
    }
}

