/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.java.prometheus.metrics.agent;

import java.io.File;
import java.io.IOException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.thisptr.java.prometheus.metrics.agent.Config;
import net.thisptr.java.prometheus.metrics.agent.PrometheusExporterServer;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.core.JsonParseException;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.JsonMappingException;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.ObjectMapper;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import net.thisptr.java.prometheus.metrics.agent.shade.javax.validation.ConstraintViolation;
import net.thisptr.java.prometheus.metrics.agent.shade.javax.validation.ConstraintViolationException;
import net.thisptr.java.prometheus.metrics.agent.shade.javax.validation.Validation;
import net.thisptr.java.prometheus.metrics.agent.shade.javax.validation.Validator;
import net.thisptr.java.prometheus.metrics.agent.shade.javax.validation.ValidatorFactory;

public class Agent {
    private static final Logger LOG = Logger.getLogger(Agent.class.getName());
    private static final ObjectMapper MAPPER = new ObjectMapper(new YAMLFactory());

    private static Config loadConfig(String args) throws JsonParseException, JsonMappingException, IOException {
        if (args == null || args.isEmpty()) {
            return new Config();
        }
        if (args.startsWith("@")) {
            return MAPPER.readValue(new File(args.substring(1)), Config.class);
        }
        return MAPPER.readValue(args, Config.class);
    }

    private static void validateConfig(Config config) {
        try (ValidatorFactory validatorFactory = Validation.buildDefaultValidatorFactory();){
            Validator validator = validatorFactory.getValidator();
            Set<ConstraintViolation<Config>> violations = validator.validate(config, new Class[0]);
            if (!violations.isEmpty()) {
                throw new ConstraintViolationException(violations);
            }
        }
    }

    public static void premain(String args) throws Throwable {
        LOG.log(Level.INFO, "Starting Prometheus Metrics Agent...");
        try {
            Config config = Agent.loadConfig(args);
            Agent.validateConfig(config);
            PrometheusExporterServer server = new PrometheusExporterServer(config);
            server.start(5000, true);
        }
        catch (Throwable th) {
            LOG.log(Level.SEVERE, "Failed to start Prometheus Metrics Agent.", th);
            throw th;
        }
    }
}

