/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.java.influxdb.reporter.shade.retrofit2;

import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.Executor;
import net.thisptr.java.influxdb.reporter.shade.retrofit2.CallAdapter;
import net.thisptr.java.influxdb.reporter.shade.retrofit2.DefaultCallAdapterFactory;
import net.thisptr.java.influxdb.reporter.shade.retrofit2.ExecutorCallAdapterFactory;
import org.codehaus.mojo.animal_sniffer.IgnoreJRERequirement;

class Platform {
    private static final Platform PLATFORM = Platform.findPlatform();

    Platform() {
    }

    static Platform get() {
        return PLATFORM;
    }

    private static Platform findPlatform() {
        try {
            Class.forName("android.os.Build");
            if (Build.VERSION.SDK_INT != 0) {
                return new Android();
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            Class.forName("java.util.Optional");
            return new Java8();
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                Class.forName("org.robovm.apple.foundation.NSObject");
                return new IOS();
            }
            catch (ClassNotFoundException classNotFoundException2) {
                return new Platform();
            }
        }
    }

    Executor defaultCallbackExecutor() {
        return null;
    }

    CallAdapter.Factory defaultCallAdapterFactory(Executor callbackExecutor) {
        if (callbackExecutor != null) {
            return new ExecutorCallAdapterFactory(callbackExecutor);
        }
        return DefaultCallAdapterFactory.INSTANCE;
    }

    boolean isDefaultMethod(Method method) {
        return false;
    }

    Object invokeDefaultMethod(Method method, Class<?> declaringClass, Object object, Object ... args) throws Throwable {
        throw new UnsupportedOperationException();
    }

    static class IOS
    extends Platform {
        IOS() {
        }

        @Override
        public Executor defaultCallbackExecutor() {
            return new MainThreadExecutor();
        }

        @Override
        CallAdapter.Factory defaultCallAdapterFactory(Executor callbackExecutor) {
            return new ExecutorCallAdapterFactory(callbackExecutor);
        }

        static class MainThreadExecutor
        implements Executor {
            private static Object queue;
            private static Method addOperation;

            MainThreadExecutor() {
            }

            @Override
            public void execute(Runnable r) {
                try {
                    addOperation.invoke(queue, r);
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    throw new AssertionError((Object)e);
                }
                catch (InvocationTargetException e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof RuntimeException) {
                        throw (RuntimeException)cause;
                    }
                    if (cause instanceof Error) {
                        throw (Error)cause;
                    }
                    throw new RuntimeException(cause);
                }
            }

            static {
                try {
                    Class<?> operationQueue = Class.forName("org.robovm.apple.foundation.NSOperationQueue");
                    queue = operationQueue.getDeclaredMethod("getMainQueue", new Class[0]).invoke(null, new Object[0]);
                    addOperation = operationQueue.getDeclaredMethod("addOperation", Runnable.class);
                }
                catch (Exception e) {
                    throw new AssertionError((Object)e);
                }
            }
        }
    }

    static class Android
    extends Platform {
        Android() {
        }

        @Override
        public Executor defaultCallbackExecutor() {
            return new MainThreadExecutor();
        }

        @Override
        CallAdapter.Factory defaultCallAdapterFactory(Executor callbackExecutor) {
            return new ExecutorCallAdapterFactory(callbackExecutor);
        }

        static class MainThreadExecutor
        implements Executor {
            private final Handler handler = new Handler(Looper.getMainLooper());

            MainThreadExecutor() {
            }

            @Override
            public void execute(Runnable r) {
                this.handler.post(r);
            }
        }
    }

    @IgnoreJRERequirement
    static class Java8
    extends Platform {
        Java8() {
        }

        @Override
        boolean isDefaultMethod(Method method) {
            return method.isDefault();
        }

        @Override
        Object invokeDefaultMethod(Method method, Class<?> declaringClass, Object object, Object ... args) throws Throwable {
            Constructor constructor = MethodHandles.Lookup.class.getDeclaredConstructor(Class.class, Integer.TYPE);
            constructor.setAccessible(true);
            return ((MethodHandles.Lookup)constructor.newInstance(declaringClass, -1)).unreflectSpecial(method, declaringClass).bindTo(object).invokeWithArguments(args);
        }
    }
}

