/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.java.influxdb.reporter.shade.org.influxdb.impl;

import java.text.SimpleDateFormat;
import java.util.EnumSet;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;

public enum TimeUtil {
    INSTANCE;

    private static final EnumSet<TimeUnit> ALLOWED_TIMEUNITS;

    public static String toTimePrecision(TimeUnit t) {
        switch (t) {
            case HOURS: {
                return "h";
            }
            case MINUTES: {
                return "m";
            }
            case SECONDS: {
                return "s";
            }
            case MILLISECONDS: {
                return "ms";
            }
            case MICROSECONDS: {
                return "u";
            }
            case NANOSECONDS: {
                return "n";
            }
        }
        throw new IllegalArgumentException("time precision must be one of:" + ALLOWED_TIMEUNITS);
    }

    public static String toInfluxDBTimeFormat(long time) {
        SimpleDateFormat dateDF = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat timeDF = new SimpleDateFormat("HH:mm:ss.SSS");
        dateDF.setTimeZone(TimeZone.getTimeZone("UTC"));
        timeDF.setTimeZone(TimeZone.getTimeZone("UTC"));
        return dateDF.format(time) + "T" + timeDF.format(time) + "Z";
    }

    public static long fromInfluxDBTimeFormat(String time) {
        try {
            String[] parts = time.split("T");
            String datePart = parts[0];
            String timePart = parts[1].substring(0, parts[1].length() - 1);
            SimpleDateFormat dateDF = new SimpleDateFormat("yyyy-MM-dd");
            SimpleDateFormat timeDF = new SimpleDateFormat("HH:mm:ss.SSS");
            dateDF.setTimeZone(TimeZone.getTimeZone("UTC"));
            timeDF.setTimeZone(TimeZone.getTimeZone("UTC"));
            return dateDF.parse(datePart).getTime() + timeDF.parse(timePart).getTime();
        }
        catch (Exception e) {
            throw new RuntimeException("unexpected date format", e);
        }
    }

    static {
        ALLOWED_TIMEUNITS = EnumSet.of(TimeUnit.HOURS, new TimeUnit[]{TimeUnit.MINUTES, TimeUnit.SECONDS, TimeUnit.MILLISECONDS, TimeUnit.MICROSECONDS, TimeUnit.NANOSECONDS});
    }
}

