/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.java.influxdb.reporter.shade.org.influxdb.impl;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import net.thisptr.java.influxdb.reporter.shade.com.google.common.base.Charsets;
import net.thisptr.java.influxdb.reporter.shade.com.google.common.base.Joiner;
import net.thisptr.java.influxdb.reporter.shade.com.google.common.base.Preconditions;
import net.thisptr.java.influxdb.reporter.shade.com.google.common.base.Stopwatch;
import net.thisptr.java.influxdb.reporter.shade.com.google.common.base.Strings;
import net.thisptr.java.influxdb.reporter.shade.com.google.common.collect.Lists;
import net.thisptr.java.influxdb.reporter.shade.okhttp3.Headers;
import net.thisptr.java.influxdb.reporter.shade.okhttp3.HttpUrl;
import net.thisptr.java.influxdb.reporter.shade.okhttp3.MediaType;
import net.thisptr.java.influxdb.reporter.shade.okhttp3.OkHttpClient;
import net.thisptr.java.influxdb.reporter.shade.okhttp3.RequestBody;
import net.thisptr.java.influxdb.reporter.shade.okhttp3.ResponseBody;
import net.thisptr.java.influxdb.reporter.shade.okhttp3.logging.HttpLoggingInterceptor;
import net.thisptr.java.influxdb.reporter.shade.org.influxdb.InfluxDB;
import net.thisptr.java.influxdb.reporter.shade.org.influxdb.dto.BatchPoints;
import net.thisptr.java.influxdb.reporter.shade.org.influxdb.dto.Point;
import net.thisptr.java.influxdb.reporter.shade.org.influxdb.dto.Pong;
import net.thisptr.java.influxdb.reporter.shade.org.influxdb.dto.Query;
import net.thisptr.java.influxdb.reporter.shade.org.influxdb.dto.QueryResult;
import net.thisptr.java.influxdb.reporter.shade.org.influxdb.impl.BatchProcessor;
import net.thisptr.java.influxdb.reporter.shade.org.influxdb.impl.GzipRequestInterceptor;
import net.thisptr.java.influxdb.reporter.shade.org.influxdb.impl.InfluxDBService;
import net.thisptr.java.influxdb.reporter.shade.org.influxdb.impl.TimeUtil;
import net.thisptr.java.influxdb.reporter.shade.retrofit2.Call;
import net.thisptr.java.influxdb.reporter.shade.retrofit2.Response;
import net.thisptr.java.influxdb.reporter.shade.retrofit2.Retrofit;
import net.thisptr.java.influxdb.reporter.shade.retrofit2.converter.moshi.MoshiConverterFactory;

public class InfluxDBImpl
implements InfluxDB {
    static final MediaType MEDIA_TYPE_STRING = MediaType.parse("text/plain");
    private static final String SHOW_DATABASE_COMMAND_ENCODED = Query.encode("SHOW DATABASES");
    private final InetAddress hostAddress;
    private final String username;
    private final String password;
    private final Retrofit retrofit;
    private final InfluxDBService influxDBService;
    private BatchProcessor batchProcessor;
    private final AtomicBoolean batchEnabled = new AtomicBoolean(false);
    private final AtomicLong writeCount = new AtomicLong();
    private final AtomicLong unBatchedCount = new AtomicLong();
    private final AtomicLong batchedCount = new AtomicLong();
    private volatile DatagramSocket datagramSocket;
    private final HttpLoggingInterceptor loggingInterceptor;
    private final GzipRequestInterceptor gzipRequestInterceptor;
    private InfluxDB.LogLevel logLevel = InfluxDB.LogLevel.NONE;

    public InfluxDBImpl(String url, String username, String password, OkHttpClient.Builder client) {
        this.hostAddress = this.parseHostAddress(url);
        this.username = username;
        this.password = password;
        this.loggingInterceptor = new HttpLoggingInterceptor();
        this.loggingInterceptor.setLevel(HttpLoggingInterceptor.Level.NONE);
        this.gzipRequestInterceptor = new GzipRequestInterceptor();
        this.retrofit = new Retrofit.Builder().baseUrl(url).client(client.addInterceptor(this.loggingInterceptor).addInterceptor(this.gzipRequestInterceptor).build()).addConverterFactory(MoshiConverterFactory.create()).build();
        this.influxDBService = this.retrofit.create(InfluxDBService.class);
    }

    private InetAddress parseHostAddress(String url) {
        try {
            return InetAddress.getByName(HttpUrl.parse(url).host());
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public InfluxDB setLogLevel(InfluxDB.LogLevel logLevel) {
        switch (logLevel) {
            case NONE: {
                this.loggingInterceptor.setLevel(HttpLoggingInterceptor.Level.NONE);
                break;
            }
            case BASIC: {
                this.loggingInterceptor.setLevel(HttpLoggingInterceptor.Level.BASIC);
                break;
            }
            case HEADERS: {
                this.loggingInterceptor.setLevel(HttpLoggingInterceptor.Level.HEADERS);
                break;
            }
            case FULL: {
                this.loggingInterceptor.setLevel(HttpLoggingInterceptor.Level.BODY);
                break;
            }
        }
        this.logLevel = logLevel;
        return this;
    }

    @Override
    public InfluxDB enableGzip() {
        this.gzipRequestInterceptor.enable();
        return this;
    }

    @Override
    public InfluxDB disableGzip() {
        this.gzipRequestInterceptor.disable();
        return this;
    }

    @Override
    public boolean isGzipEnabled() {
        return this.gzipRequestInterceptor.isEnabled();
    }

    @Override
    public InfluxDB enableBatch(int actions, int flushDuration, TimeUnit flushDurationTimeUnit) {
        this.enableBatch(actions, flushDuration, flushDurationTimeUnit, Executors.defaultThreadFactory());
        return this;
    }

    @Override
    public InfluxDB enableBatch(int actions, int flushDuration, TimeUnit flushDurationTimeUnit, ThreadFactory threadFactory) {
        if (this.batchEnabled.get()) {
            throw new IllegalStateException("BatchProcessing is already enabled.");
        }
        this.batchProcessor = BatchProcessor.builder(this).actions(actions).interval(flushDuration, flushDurationTimeUnit).threadFactory(threadFactory).build();
        this.batchEnabled.set(true);
        return this;
    }

    @Override
    public void disableBatch() {
        this.batchEnabled.set(false);
        if (this.batchProcessor != null) {
            this.batchProcessor.flush();
            if (this.logLevel != InfluxDB.LogLevel.NONE) {
                System.out.println("total writes:" + this.writeCount.get() + " unbatched:" + this.unBatchedCount.get() + " batchPoints:" + this.batchedCount);
            }
        }
    }

    @Override
    public boolean isBatchEnabled() {
        return this.batchEnabled.get();
    }

    @Override
    public Pong ping() {
        Stopwatch watch = Stopwatch.createStarted();
        Call<ResponseBody> call = this.influxDBService.ping();
        try {
            Response<ResponseBody> response = call.execute();
            Headers headers = response.headers();
            String version = "unknown";
            for (String name : headers.toMultimap().keySet()) {
                if (null == name || !"X-Influxdb-Version".equalsIgnoreCase(name)) continue;
                version = headers.get(name);
                break;
            }
            Pong pong = new Pong();
            pong.setVersion(version);
            pong.setResponseTime(watch.elapsed(TimeUnit.MILLISECONDS));
            return pong;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String version() {
        return this.ping().getVersion();
    }

    @Override
    public void write(String database, String retentionPolicy, Point point) {
        if (this.batchEnabled.get()) {
            BatchProcessor.HttpBatchEntry batchEntry = new BatchProcessor.HttpBatchEntry(point, database, retentionPolicy);
            this.batchProcessor.put(batchEntry);
        } else {
            BatchPoints batchPoints = BatchPoints.database(database).retentionPolicy(retentionPolicy).build();
            batchPoints.point(point);
            this.write(batchPoints);
            this.unBatchedCount.incrementAndGet();
        }
        this.writeCount.incrementAndGet();
    }

    @Override
    public void write(int udpPort, Point point) {
        if (this.batchEnabled.get()) {
            BatchProcessor.UdpBatchEntry batchEntry = new BatchProcessor.UdpBatchEntry(point, udpPort);
            this.batchProcessor.put(batchEntry);
        } else {
            this.write(udpPort, point.lineProtocol());
            this.unBatchedCount.incrementAndGet();
        }
        this.writeCount.incrementAndGet();
    }

    @Override
    public void write(BatchPoints batchPoints) {
        this.batchedCount.addAndGet(batchPoints.getPoints().size());
        RequestBody lineProtocol = RequestBody.create(MEDIA_TYPE_STRING, batchPoints.lineProtocol());
        this.execute(this.influxDBService.writePoints(this.username, this.password, batchPoints.getDatabase(), batchPoints.getRetentionPolicy(), TimeUtil.toTimePrecision(TimeUnit.NANOSECONDS), batchPoints.getConsistency().value(), lineProtocol));
    }

    @Override
    public void write(String database, String retentionPolicy, InfluxDB.ConsistencyLevel consistency, String records) {
        this.execute(this.influxDBService.writePoints(this.username, this.password, database, retentionPolicy, TimeUtil.toTimePrecision(TimeUnit.NANOSECONDS), consistency.value(), RequestBody.create(MEDIA_TYPE_STRING, records)));
    }

    @Override
    public void write(String database, String retentionPolicy, InfluxDB.ConsistencyLevel consistency, List<String> records) {
        String joinedRecords = Joiner.on("\n").join(records);
        this.write(database, retentionPolicy, consistency, joinedRecords);
    }

    @Override
    public void write(int udpPort, String records) {
        this.initialDatagramSocket();
        byte[] bytes = records.getBytes(Charsets.UTF_8);
        try {
            this.datagramSocket.send(new DatagramPacket(bytes, bytes.length, this.hostAddress, udpPort));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initialDatagramSocket() {
        if (this.datagramSocket != null) return;
        Class<InfluxDBImpl> clazz = InfluxDBImpl.class;
        synchronized (InfluxDBImpl.class) {
            if (this.datagramSocket != null) return;
            try {
                this.datagramSocket = new DatagramSocket();
            }
            catch (SocketException e) {
                throw new RuntimeException(e);
            }
            return;
        }
    }

    @Override
    public void write(int udpPort, List<String> records) {
        String joinedRecords = Joiner.on("\n").join(records);
        this.write(udpPort, joinedRecords);
    }

    @Override
    public QueryResult query(Query query) {
        Call<QueryResult> call = query.requiresPost() ? this.influxDBService.postQuery(this.username, this.password, query.getDatabase(), query.getCommandWithUrlEncoded()) : this.influxDBService.query(this.username, this.password, query.getDatabase(), query.getCommandWithUrlEncoded());
        return this.execute(call);
    }

    @Override
    public QueryResult query(Query query, TimeUnit timeUnit) {
        return this.execute(this.influxDBService.query(this.username, this.password, query.getDatabase(), TimeUtil.toTimePrecision(timeUnit), query.getCommandWithUrlEncoded()));
    }

    @Override
    public void createDatabase(String name) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(name), "Database name may not be null or empty");
        String createDatabaseQueryString = String.format("CREATE DATABASE \"%s\"", name);
        if (this.version().startsWith("0.")) {
            createDatabaseQueryString = String.format("CREATE DATABASE IF NOT EXISTS \"%s\"", name);
        }
        this.execute(this.influxDBService.postQuery(this.username, this.password, Query.encode(createDatabaseQueryString)));
    }

    @Override
    public void deleteDatabase(String name) {
        this.execute(this.influxDBService.postQuery(this.username, this.password, Query.encode("DROP DATABASE \"" + name + "\"")));
    }

    @Override
    public List<String> describeDatabases() {
        QueryResult result = this.execute(this.influxDBService.query(this.username, this.password, SHOW_DATABASE_COMMAND_ENCODED));
        List<List<Object>> databaseNames = result.getResults().get(0).getSeries().get(0).getValues();
        ArrayList<String> databases = Lists.newArrayList();
        if (databaseNames != null) {
            for (List<Object> database : databaseNames) {
                databases.add(database.get(0).toString());
            }
        }
        return databases;
    }

    private <T> T execute(Call<T> call) {
        try {
            Response<T> response = call.execute();
            if (response.isSuccessful()) {
                return response.body();
            }
            ResponseBody errorBody = response.errorBody();
            Throwable throwable = null;
            try {
                try {
                    throw new RuntimeException(errorBody.string());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (Throwable throwable3) {
                if (errorBody != null) {
                    if (throwable != null) {
                        try {
                            errorBody.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                    } else {
                        errorBody.close();
                    }
                }
                throw throwable3;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() {
        try {
            this.disableBatch();
        }
        finally {
            if (this.datagramSocket != null && !this.datagramSocket.isClosed()) {
                this.datagramSocket.close();
            }
        }
    }
}

