/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.java.influxdb.reporter.shade.org.influxdb.impl;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import net.thisptr.java.influxdb.reporter.shade.okhttp3.Interceptor;
import net.thisptr.java.influxdb.reporter.shade.okhttp3.MediaType;
import net.thisptr.java.influxdb.reporter.shade.okhttp3.Request;
import net.thisptr.java.influxdb.reporter.shade.okhttp3.RequestBody;
import net.thisptr.java.influxdb.reporter.shade.okhttp3.Response;
import net.thisptr.java.influxdb.reporter.shade.okio.BufferedSink;
import net.thisptr.java.influxdb.reporter.shade.okio.GzipSink;
import net.thisptr.java.influxdb.reporter.shade.okio.Okio;

final class GzipRequestInterceptor
implements Interceptor {
    private AtomicBoolean enabled = new AtomicBoolean(false);

    GzipRequestInterceptor() {
    }

    public void enable() {
        this.enabled.set(true);
    }

    public boolean isEnabled() {
        return this.enabled.get();
    }

    public void disable() {
        this.enabled.set(false);
    }

    @Override
    public Response intercept(Interceptor.Chain chain) throws IOException {
        if (!this.enabled.get()) {
            return chain.proceed(chain.request());
        }
        Request originalRequest = chain.request();
        RequestBody body = originalRequest.body();
        if (body == null || originalRequest.header("Content-Encoding") != null) {
            return chain.proceed(originalRequest);
        }
        Request compressedRequest = originalRequest.newBuilder().header("Content-Encoding", "gzip").method(originalRequest.method(), this.gzip(body)).build();
        return chain.proceed(compressedRequest);
    }

    private RequestBody gzip(final RequestBody body) {
        return new RequestBody(){

            @Override
            public MediaType contentType() {
                return body.contentType();
            }

            @Override
            public long contentLength() {
                return -1L;
            }

            @Override
            public void writeTo(BufferedSink sink) throws IOException {
                BufferedSink gzipSink = Okio.buffer(new GzipSink(sink));
                body.writeTo(gzipSink);
                gzipSink.close();
            }
        };
    }
}

