/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.java.influxdb.reporter.shade.org.influxdb;

import net.thisptr.java.influxdb.reporter.shade.com.google.common.base.Preconditions;
import net.thisptr.java.influxdb.reporter.shade.com.google.common.base.Strings;
import net.thisptr.java.influxdb.reporter.shade.okhttp3.OkHttpClient;
import net.thisptr.java.influxdb.reporter.shade.org.influxdb.InfluxDB;
import net.thisptr.java.influxdb.reporter.shade.org.influxdb.impl.InfluxDBImpl;

public enum InfluxDBFactory {
    INSTANCE;


    public static InfluxDB connect(String url) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(url), "The URL may not be null or empty.");
        return new InfluxDBImpl(url, null, null, new OkHttpClient.Builder());
    }

    public static InfluxDB connect(String url, String username, String password) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(url), "The URL may not be null or empty.");
        Preconditions.checkArgument(!Strings.isNullOrEmpty(username), "The username may not be null or empty.");
        return new InfluxDBImpl(url, username, password, new OkHttpClient.Builder());
    }

    public static InfluxDB connect(String url, OkHttpClient.Builder client) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(url), "The URL may not be null or empty.");
        Preconditions.checkNotNull(client, "The client may not be null.");
        return new InfluxDBImpl(url, null, null, client);
    }

    public static InfluxDB connect(String url, String username, String password, OkHttpClient.Builder client) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(url), "The URL may not be null or empty.");
        Preconditions.checkArgument(!Strings.isNullOrEmpty(username), "The username may not be null or empty.");
        Preconditions.checkNotNull(client, "The client may not be null.");
        return new InfluxDBImpl(url, username, password, client);
    }
}

