/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.java.influxdb.reporter.shade.okhttp3.internal.http;

import java.io.IOException;
import java.net.ProtocolException;
import net.thisptr.java.influxdb.reporter.shade.okhttp3.Interceptor;
import net.thisptr.java.influxdb.reporter.shade.okhttp3.Request;
import net.thisptr.java.influxdb.reporter.shade.okhttp3.Response;
import net.thisptr.java.influxdb.reporter.shade.okhttp3.internal.Util;
import net.thisptr.java.influxdb.reporter.shade.okhttp3.internal.connection.StreamAllocation;
import net.thisptr.java.influxdb.reporter.shade.okhttp3.internal.http.HttpCodec;
import net.thisptr.java.influxdb.reporter.shade.okhttp3.internal.http.HttpMethod;
import net.thisptr.java.influxdb.reporter.shade.okhttp3.internal.http.RealInterceptorChain;
import net.thisptr.java.influxdb.reporter.shade.okio.BufferedSink;
import net.thisptr.java.influxdb.reporter.shade.okio.Okio;
import net.thisptr.java.influxdb.reporter.shade.okio.Sink;

public final class CallServerInterceptor
implements Interceptor {
    private final boolean forWebSocket;

    public CallServerInterceptor(boolean forWebSocket) {
        this.forWebSocket = forWebSocket;
    }

    @Override
    public Response intercept(Interceptor.Chain chain) throws IOException {
        HttpCodec httpCodec = ((RealInterceptorChain)chain).httpStream();
        StreamAllocation streamAllocation = ((RealInterceptorChain)chain).streamAllocation();
        Request request = chain.request();
        long sentRequestMillis = System.currentTimeMillis();
        httpCodec.writeRequestHeaders(request);
        if (HttpMethod.permitsRequestBody(request.method()) && request.body() != null) {
            Sink requestBodyOut = httpCodec.createRequestBody(request, request.body().contentLength());
            BufferedSink bufferedRequestBody = Okio.buffer(requestBodyOut);
            request.body().writeTo(bufferedRequestBody);
            bufferedRequestBody.close();
        }
        httpCodec.finishRequest();
        Response response = httpCodec.readResponseHeaders().request(request).handshake(streamAllocation.connection().handshake()).sentRequestAtMillis(sentRequestMillis).receivedResponseAtMillis(System.currentTimeMillis()).build();
        int code = response.code();
        response = this.forWebSocket && code == 101 ? response.newBuilder().body(Util.EMPTY_RESPONSE).build() : response.newBuilder().body(httpCodec.openResponseBody(response)).build();
        if ("close".equalsIgnoreCase(response.request().header("Connection")) || "close".equalsIgnoreCase(response.header("Connection"))) {
            streamAllocation.noNewStreams();
        }
        if ((code == 204 || code == 205) && response.body().contentLength() > 0L) {
            throw new ProtocolException("HTTP " + code + " had non-zero Content-Length: " + response.body().contentLength());
        }
        return response;
    }
}

