/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.java.influxdb.reporter.shade.okhttp3.internal.connection;

import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.concurrent.TimeUnit;
import net.thisptr.java.influxdb.reporter.shade.okhttp3.Address;
import net.thisptr.java.influxdb.reporter.shade.okhttp3.ConnectionPool;
import net.thisptr.java.influxdb.reporter.shade.okhttp3.OkHttpClient;
import net.thisptr.java.influxdb.reporter.shade.okhttp3.Route;
import net.thisptr.java.influxdb.reporter.shade.okhttp3.internal.Internal;
import net.thisptr.java.influxdb.reporter.shade.okhttp3.internal.Util;
import net.thisptr.java.influxdb.reporter.shade.okhttp3.internal.connection.RealConnection;
import net.thisptr.java.influxdb.reporter.shade.okhttp3.internal.connection.RouteDatabase;
import net.thisptr.java.influxdb.reporter.shade.okhttp3.internal.connection.RouteException;
import net.thisptr.java.influxdb.reporter.shade.okhttp3.internal.connection.RouteSelector;
import net.thisptr.java.influxdb.reporter.shade.okhttp3.internal.http.HttpCodec;
import net.thisptr.java.influxdb.reporter.shade.okhttp3.internal.http1.Http1Codec;
import net.thisptr.java.influxdb.reporter.shade.okhttp3.internal.http2.ConnectionShutdownException;
import net.thisptr.java.influxdb.reporter.shade.okhttp3.internal.http2.ErrorCode;
import net.thisptr.java.influxdb.reporter.shade.okhttp3.internal.http2.Http2Codec;
import net.thisptr.java.influxdb.reporter.shade.okhttp3.internal.http2.StreamResetException;

public final class StreamAllocation {
    public final Address address;
    private Route route;
    private final ConnectionPool connectionPool;
    private final Object callStackTrace;
    private final RouteSelector routeSelector;
    private int refusedStreamCount;
    private RealConnection connection;
    private boolean released;
    private boolean canceled;
    private HttpCodec codec;

    public StreamAllocation(ConnectionPool connectionPool, Address address, Object callStackTrace) {
        this.connectionPool = connectionPool;
        this.address = address;
        this.routeSelector = new RouteSelector(address, this.routeDatabase());
        this.callStackTrace = callStackTrace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpCodec newStream(OkHttpClient client, boolean doExtensiveHealthChecks) {
        int connectTimeout = client.connectTimeoutMillis();
        int readTimeout = client.readTimeoutMillis();
        int writeTimeout = client.writeTimeoutMillis();
        boolean connectionRetryEnabled = client.retryOnConnectionFailure();
        try {
            HttpCodec resultCodec;
            RealConnection resultConnection = this.findHealthyConnection(connectTimeout, readTimeout, writeTimeout, connectionRetryEnabled, doExtensiveHealthChecks);
            if (resultConnection.http2Connection != null) {
                resultCodec = new Http2Codec(client, this, resultConnection.http2Connection);
            } else {
                resultConnection.socket().setSoTimeout(readTimeout);
                resultConnection.source.timeout().timeout(readTimeout, TimeUnit.MILLISECONDS);
                resultConnection.sink.timeout().timeout(writeTimeout, TimeUnit.MILLISECONDS);
                resultCodec = new Http1Codec(client, this, resultConnection.source, resultConnection.sink);
            }
            ConnectionPool connectionPool = this.connectionPool;
            synchronized (connectionPool) {
                this.codec = resultCodec;
                return resultCodec;
            }
        }
        catch (IOException e) {
            throw new RouteException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RealConnection findHealthyConnection(int connectTimeout, int readTimeout, int writeTimeout, boolean connectionRetryEnabled, boolean doExtensiveHealthChecks) throws IOException {
        RealConnection candidate;
        while (true) {
            candidate = this.findConnection(connectTimeout, readTimeout, writeTimeout, connectionRetryEnabled);
            ConnectionPool connectionPool = this.connectionPool;
            synchronized (connectionPool) {
                if (candidate.successCount == 0) {
                    return candidate;
                }
            }
            if (candidate.isHealthy(doExtensiveHealthChecks)) break;
            this.noNewStreams();
        }
        return candidate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RealConnection findConnection(int connectTimeout, int readTimeout, int writeTimeout, boolean connectionRetryEnabled) throws IOException {
        Route selectedRoute;
        ConnectionPool connectionPool = this.connectionPool;
        synchronized (connectionPool) {
            if (this.released) {
                throw new IllegalStateException("released");
            }
            if (this.codec != null) {
                throw new IllegalStateException("codec != null");
            }
            if (this.canceled) {
                throw new IOException("Canceled");
            }
            RealConnection allocatedConnection = this.connection;
            if (allocatedConnection != null && !allocatedConnection.noNewStreams) {
                return allocatedConnection;
            }
            RealConnection pooledConnection = Internal.instance.get(this.connectionPool, this.address, this);
            if (pooledConnection != null) {
                this.connection = pooledConnection;
                return pooledConnection;
            }
            selectedRoute = this.route;
        }
        if (selectedRoute == null) {
            selectedRoute = this.routeSelector.next();
            connectionPool = this.connectionPool;
            synchronized (connectionPool) {
                this.route = selectedRoute;
                this.refusedStreamCount = 0;
            }
        }
        RealConnection newConnection = new RealConnection(selectedRoute);
        ConnectionPool connectionPool2 = this.connectionPool;
        synchronized (connectionPool2) {
            this.acquire(newConnection);
            Internal.instance.put(this.connectionPool, newConnection);
            this.connection = newConnection;
            if (this.canceled) {
                throw new IOException("Canceled");
            }
        }
        newConnection.connect(connectTimeout, readTimeout, writeTimeout, this.address.connectionSpecs(), connectionRetryEnabled);
        this.routeDatabase().connected(newConnection.route());
        return newConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void streamFinished(boolean noNewStreams, HttpCodec codec) {
        ConnectionPool connectionPool = this.connectionPool;
        synchronized (connectionPool) {
            if (codec == null || codec != this.codec) {
                throw new IllegalStateException("expected " + this.codec + " but was " + codec);
            }
            if (!noNewStreams) {
                ++this.connection.successCount;
            }
        }
        this.deallocate(noNewStreams, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpCodec codec() {
        ConnectionPool connectionPool = this.connectionPool;
        synchronized (connectionPool) {
            return this.codec;
        }
    }

    private RouteDatabase routeDatabase() {
        return Internal.instance.routeDatabase(this.connectionPool);
    }

    public synchronized RealConnection connection() {
        return this.connection;
    }

    public void release() {
        this.deallocate(false, true, false);
    }

    public void noNewStreams() {
        this.deallocate(true, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deallocate(boolean noNewStreams, boolean released, boolean streamFinished) {
        RealConnection connectionToClose = null;
        ConnectionPool connectionPool = this.connectionPool;
        synchronized (connectionPool) {
            if (streamFinished) {
                this.codec = null;
            }
            if (released) {
                this.released = true;
            }
            if (this.connection != null) {
                if (noNewStreams) {
                    this.connection.noNewStreams = true;
                }
                if (this.codec == null && (this.released || this.connection.noNewStreams)) {
                    this.release(this.connection);
                    if (this.connection.allocations.isEmpty()) {
                        this.connection.idleAtNanos = System.nanoTime();
                        if (Internal.instance.connectionBecameIdle(this.connectionPool, this.connection)) {
                            connectionToClose = this.connection;
                        }
                    }
                    this.connection = null;
                }
            }
        }
        if (connectionToClose != null) {
            Util.closeQuietly(connectionToClose.socket());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        RealConnection connectionToCancel;
        HttpCodec codecToCancel;
        ConnectionPool connectionPool = this.connectionPool;
        synchronized (connectionPool) {
            this.canceled = true;
            codecToCancel = this.codec;
            connectionToCancel = this.connection;
        }
        if (codecToCancel != null) {
            codecToCancel.cancel();
        } else if (connectionToCancel != null) {
            connectionToCancel.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void streamFailed(IOException e) {
        boolean noNewStreams = false;
        ConnectionPool connectionPool = this.connectionPool;
        synchronized (connectionPool) {
            if (e instanceof StreamResetException) {
                StreamResetException streamResetException = (StreamResetException)e;
                if (streamResetException.errorCode == ErrorCode.REFUSED_STREAM) {
                    ++this.refusedStreamCount;
                }
                if (streamResetException.errorCode != ErrorCode.REFUSED_STREAM || this.refusedStreamCount > 1) {
                    noNewStreams = true;
                    this.route = null;
                }
            } else if (this.connection != null && !this.connection.isMultiplexed() || e instanceof ConnectionShutdownException) {
                noNewStreams = true;
                if (this.connection.successCount == 0) {
                    if (this.route != null && e != null) {
                        this.routeSelector.connectFailed(this.route, e);
                    }
                    this.route = null;
                }
            }
        }
        this.deallocate(noNewStreams, false, true);
    }

    public void acquire(RealConnection connection) {
        assert (Thread.holdsLock(this.connectionPool));
        connection.allocations.add(new StreamAllocationReference(this, this.callStackTrace));
    }

    private void release(RealConnection connection) {
        int size = connection.allocations.size();
        for (int i = 0; i < size; ++i) {
            Reference<StreamAllocation> reference = connection.allocations.get(i);
            if (reference.get() != this) continue;
            connection.allocations.remove(i);
            return;
        }
        throw new IllegalStateException();
    }

    public boolean hasMoreRoutes() {
        return this.route != null || this.routeSelector.hasNext();
    }

    public String toString() {
        return this.address.toString();
    }

    public static final class StreamAllocationReference
    extends WeakReference<StreamAllocation> {
        public final Object callStackTrace;

        StreamAllocationReference(StreamAllocation referent, Object callStackTrace) {
            super(referent);
            this.callStackTrace = callStackTrace;
        }
    }
}

