/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.java.influxdb.reporter.shade.com.squareup.moshi;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.thisptr.java.influxdb.reporter.shade.com.squareup.moshi.ClassFactory;
import net.thisptr.java.influxdb.reporter.shade.com.squareup.moshi.Json;
import net.thisptr.java.influxdb.reporter.shade.com.squareup.moshi.JsonAdapter;
import net.thisptr.java.influxdb.reporter.shade.com.squareup.moshi.JsonReader;
import net.thisptr.java.influxdb.reporter.shade.com.squareup.moshi.JsonWriter;
import net.thisptr.java.influxdb.reporter.shade.com.squareup.moshi.Moshi;
import net.thisptr.java.influxdb.reporter.shade.com.squareup.moshi.Types;
import net.thisptr.java.influxdb.reporter.shade.com.squareup.moshi.Util;

final class ClassJsonAdapter<T>
extends JsonAdapter<T> {
    public static final JsonAdapter.Factory FACTORY = new JsonAdapter.Factory(){

        @Override
        public JsonAdapter<?> create(Type type, Set<? extends Annotation> annotations, Moshi moshi) {
            Class<?> rawType = Types.getRawType(type);
            if (rawType.isInterface() || rawType.isEnum()) {
                return null;
            }
            if (this.isPlatformType(rawType)) {
                throw new IllegalArgumentException("Platform " + type + " annotated " + annotations + " requires explicit JsonAdapter to be registered");
            }
            if (!annotations.isEmpty()) {
                return null;
            }
            if (rawType.getEnclosingClass() != null && !Modifier.isStatic(rawType.getModifiers())) {
                if (rawType.getSimpleName().isEmpty()) {
                    throw new IllegalArgumentException("Cannot serialize anonymous class " + rawType.getName());
                }
                throw new IllegalArgumentException("Cannot serialize non-static nested class " + rawType.getName());
            }
            if (Modifier.isAbstract(rawType.getModifiers())) {
                throw new IllegalArgumentException("Cannot serialize abstract class " + rawType.getName());
            }
            ClassFactory classFactory = ClassFactory.get(rawType);
            TreeMap fields = new TreeMap();
            Type t = type;
            while (t != Object.class) {
                this.createFieldBindings(moshi, t, fields);
                t = Types.getGenericSuperclass(t);
            }
            return new ClassJsonAdapter(classFactory, fields).nullSafe();
        }

        private void createFieldBindings(Moshi moshi, Type type, Map<String, FieldBinding<?>> fieldBindings) {
            Class<?> rawType = Types.getRawType(type);
            boolean platformType = this.isPlatformType(rawType);
            for (Field field : rawType.getDeclaredFields()) {
                if (!this.includeField(platformType, field.getModifiers())) continue;
                Type fieldType = Types.resolve(type, rawType, field.getGenericType());
                Set<? extends Annotation> annotations = Util.jsonAnnotations(field);
                JsonAdapter adapter = moshi.adapter(fieldType, annotations);
                field.setAccessible(true);
                Json jsonAnnotation = field.getAnnotation(Json.class);
                String name = jsonAnnotation != null ? jsonAnnotation.name() : field.getName();
                FieldBinding fieldBinding = new FieldBinding(name, field, adapter);
                FieldBinding replaced = fieldBindings.put(name, fieldBinding);
                if (replaced == null) continue;
                throw new IllegalArgumentException("Conflicting fields:\n    " + replaced.field + "\n    " + fieldBinding.field);
            }
        }

        private boolean isPlatformType(Class<?> rawType) {
            return rawType.getName().startsWith("java.") || rawType.getName().startsWith("javax.") || rawType.getName().startsWith("android.");
        }

        private boolean includeField(boolean platformType, int modifiers) {
            if (Modifier.isStatic(modifiers) || Modifier.isTransient(modifiers)) {
                return false;
            }
            return Modifier.isPublic(modifiers) || Modifier.isProtected(modifiers) || !platformType;
        }
    };
    private final ClassFactory<T> classFactory;
    private final Map<String, FieldBinding<?>> fieldsMap;
    private final FieldBinding<?>[] fieldsArray;
    private final JsonReader.Options options;

    ClassJsonAdapter(ClassFactory<T> classFactory, Map<String, FieldBinding<?>> fieldsMap) {
        this.classFactory = classFactory;
        this.fieldsMap = new LinkedHashMap(fieldsMap);
        this.fieldsArray = fieldsMap.values().toArray(new FieldBinding[fieldsMap.size()]);
        this.options = JsonReader.Options.of(fieldsMap.keySet().toArray(new String[fieldsMap.size()]));
    }

    @Override
    public T fromJson(JsonReader reader) throws IOException {
        T result;
        try {
            result = this.classFactory.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            if (targetException instanceof RuntimeException) {
                throw (RuntimeException)targetException;
            }
            if (targetException instanceof Error) {
                throw (Error)targetException;
            }
            throw new RuntimeException(targetException);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError();
        }
        try {
            reader.beginObject();
            while (reader.hasNext()) {
                FieldBinding<?> fieldBinding;
                int index = reader.selectName(this.options);
                if (index != -1) {
                    fieldBinding = this.fieldsArray[index];
                } else {
                    String name = reader.nextName();
                    fieldBinding = this.fieldsMap.get(name);
                    if (fieldBinding == null) {
                        reader.skipValue();
                        continue;
                    }
                }
                fieldBinding.read(reader, result);
            }
            reader.endObject();
            return result;
        }
        catch (IllegalAccessException e) {
            throw new AssertionError();
        }
    }

    @Override
    public void toJson(JsonWriter writer, T value) throws IOException {
        try {
            writer.beginObject();
            for (FieldBinding<?> fieldBinding : this.fieldsArray) {
                writer.name(fieldBinding.name);
                fieldBinding.write(writer, value);
            }
            writer.endObject();
        }
        catch (IllegalAccessException e) {
            throw new AssertionError();
        }
    }

    public String toString() {
        return "JsonAdapter(" + this.classFactory + ")";
    }

    static class FieldBinding<T> {
        final String name;
        final Field field;
        final JsonAdapter<T> adapter;

        public FieldBinding(String name, Field field, JsonAdapter<T> adapter) {
            this.name = name;
            this.field = field;
            this.adapter = adapter;
        }

        void read(JsonReader reader, Object value) throws IOException, IllegalAccessException {
            T fieldValue = this.adapter.fromJson(reader);
            this.field.set(value, fieldValue);
        }

        void write(JsonWriter writer, Object value) throws IllegalAccessException, IOException {
            Object fieldValue = this.field.get(value);
            this.adapter.toJson(writer, fieldValue);
        }
    }
}

