/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.java.influxdb.reporter.shade.com.squareup.moshi;

import java.io.EOFException;
import java.io.IOException;
import net.thisptr.java.influxdb.reporter.shade.com.squareup.moshi.JsonDataException;
import net.thisptr.java.influxdb.reporter.shade.com.squareup.moshi.JsonReader;
import net.thisptr.java.influxdb.reporter.shade.com.squareup.moshi.JsonScope;
import net.thisptr.java.influxdb.reporter.shade.okio.Buffer;
import net.thisptr.java.influxdb.reporter.shade.okio.BufferedSource;
import net.thisptr.java.influxdb.reporter.shade.okio.ByteString;

final class BufferedSourceJsonReader
extends JsonReader {
    private static final long MIN_INCOMPLETE_INTEGER = -922337203685477580L;
    private static final ByteString SINGLE_QUOTE_OR_SLASH = ByteString.encodeUtf8("'\\");
    private static final ByteString DOUBLE_QUOTE_OR_SLASH = ByteString.encodeUtf8("\"\\");
    private static final ByteString UNQUOTED_STRING_TERMINALS = ByteString.encodeUtf8("{}[]:, \n\t\r\f/\\;#=");
    private static final ByteString LINEFEED_OR_CARRIAGE_RETURN = ByteString.encodeUtf8("\n\r");
    private static final int PEEKED_NONE = 0;
    private static final int PEEKED_BEGIN_OBJECT = 1;
    private static final int PEEKED_END_OBJECT = 2;
    private static final int PEEKED_BEGIN_ARRAY = 3;
    private static final int PEEKED_END_ARRAY = 4;
    private static final int PEEKED_TRUE = 5;
    private static final int PEEKED_FALSE = 6;
    private static final int PEEKED_NULL = 7;
    private static final int PEEKED_SINGLE_QUOTED = 8;
    private static final int PEEKED_DOUBLE_QUOTED = 9;
    private static final int PEEKED_UNQUOTED = 10;
    private static final int PEEKED_BUFFERED = 11;
    private static final int PEEKED_SINGLE_QUOTED_NAME = 12;
    private static final int PEEKED_DOUBLE_QUOTED_NAME = 13;
    private static final int PEEKED_UNQUOTED_NAME = 14;
    private static final int PEEKED_LONG = 15;
    private static final int PEEKED_NUMBER = 16;
    private static final int PEEKED_EOF = 17;
    private static final int NUMBER_CHAR_NONE = 0;
    private static final int NUMBER_CHAR_SIGN = 1;
    private static final int NUMBER_CHAR_DIGIT = 2;
    private static final int NUMBER_CHAR_DECIMAL = 3;
    private static final int NUMBER_CHAR_FRACTION_DIGIT = 4;
    private static final int NUMBER_CHAR_EXP_E = 5;
    private static final int NUMBER_CHAR_EXP_SIGN = 6;
    private static final int NUMBER_CHAR_EXP_DIGIT = 7;
    private boolean lenient = false;
    private boolean failOnUnknown = false;
    private final BufferedSource source;
    private final Buffer buffer;
    private int peeked = 0;
    private long peekedLong;
    private int peekedNumberLength;
    private String peekedString;
    private int[] stack = new int[32];
    private int stackSize = 0;
    private String[] pathNames;
    private int[] pathIndices;

    BufferedSourceJsonReader(BufferedSource source) {
        this.stack[this.stackSize++] = 6;
        this.pathNames = new String[32];
        this.pathIndices = new int[32];
        if (source == null) {
            throw new NullPointerException("source == null");
        }
        this.source = source;
        this.buffer = source.buffer();
    }

    @Override
    public void setLenient(boolean lenient) {
        this.lenient = lenient;
    }

    @Override
    public boolean isLenient() {
        return this.lenient;
    }

    @Override
    public void setFailOnUnknown(boolean failOnUnknown) {
        this.failOnUnknown = failOnUnknown;
    }

    @Override
    public boolean failOnUnknown() {
        return this.failOnUnknown;
    }

    @Override
    public void beginArray() throws IOException {
        int p = this.peeked;
        if (p == 0) {
            p = this.doPeek();
        }
        if (p != 3) {
            throw new JsonDataException("Expected BEGIN_ARRAY but was " + (Object)((Object)this.peek()) + " at path " + this.getPath());
        }
        this.push(1);
        this.pathIndices[this.stackSize - 1] = 0;
        this.peeked = 0;
    }

    @Override
    public void endArray() throws IOException {
        int p = this.peeked;
        if (p == 0) {
            p = this.doPeek();
        }
        if (p == 4) {
            --this.stackSize;
        } else {
            throw new JsonDataException("Expected END_ARRAY but was " + (Object)((Object)this.peek()) + " at path " + this.getPath());
        }
        int n = this.stackSize - 1;
        this.pathIndices[n] = this.pathIndices[n] + 1;
        this.peeked = 0;
    }

    @Override
    public void beginObject() throws IOException {
        int p = this.peeked;
        if (p == 0) {
            p = this.doPeek();
        }
        if (p != 1) {
            throw new JsonDataException("Expected BEGIN_OBJECT but was " + (Object)((Object)this.peek()) + " at path " + this.getPath());
        }
        this.push(3);
        this.peeked = 0;
    }

    @Override
    public void endObject() throws IOException {
        int p = this.peeked;
        if (p == 0) {
            p = this.doPeek();
        }
        if (p == 2) {
            --this.stackSize;
        } else {
            throw new JsonDataException("Expected END_OBJECT but was " + (Object)((Object)this.peek()) + " at path " + this.getPath());
        }
        this.pathNames[this.stackSize] = null;
        int n = this.stackSize - 1;
        this.pathIndices[n] = this.pathIndices[n] + 1;
        this.peeked = 0;
    }

    @Override
    public boolean hasNext() throws IOException {
        int p = this.peeked;
        if (p == 0) {
            p = this.doPeek();
        }
        return p != 2 && p != 4;
    }

    @Override
    public JsonReader.Token peek() throws IOException {
        int p = this.peeked;
        if (p == 0) {
            p = this.doPeek();
        }
        switch (p) {
            case 1: {
                return JsonReader.Token.BEGIN_OBJECT;
            }
            case 2: {
                return JsonReader.Token.END_OBJECT;
            }
            case 3: {
                return JsonReader.Token.BEGIN_ARRAY;
            }
            case 4: {
                return JsonReader.Token.END_ARRAY;
            }
            case 12: 
            case 13: 
            case 14: {
                return JsonReader.Token.NAME;
            }
            case 5: 
            case 6: {
                return JsonReader.Token.BOOLEAN;
            }
            case 7: {
                return JsonReader.Token.NULL;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                return JsonReader.Token.STRING;
            }
            case 15: 
            case 16: {
                return JsonReader.Token.NUMBER;
            }
            case 17: {
                return JsonReader.Token.END_DOCUMENT;
            }
        }
        throw new AssertionError();
    }

    private int doPeek() throws IOException {
        int c;
        int peekStack;
        block44: {
            block46: {
                block45: {
                    block43: {
                        peekStack = this.stack[this.stackSize - 1];
                        if (peekStack != 1) break block43;
                        this.stack[this.stackSize - 1] = 2;
                        break block44;
                    }
                    if (peekStack != 2) break block45;
                    c = this.nextNonWhitespace(true);
                    this.buffer.readByte();
                    switch (c) {
                        case 93: {
                            this.peeked = 4;
                            return 4;
                        }
                        case 59: {
                            this.checkLenient();
                        }
                        case 44: {
                            break;
                        }
                        default: {
                            throw this.syntaxError("Unterminated array");
                        }
                    }
                    break block44;
                }
                if (peekStack == 3 || peekStack == 5) {
                    int c2;
                    this.stack[this.stackSize - 1] = 4;
                    if (peekStack == 5) {
                        c2 = this.nextNonWhitespace(true);
                        this.buffer.readByte();
                        switch (c2) {
                            case 125: {
                                this.peeked = 2;
                                return 2;
                            }
                            case 59: {
                                this.checkLenient();
                            }
                            case 44: {
                                break;
                            }
                            default: {
                                throw this.syntaxError("Unterminated object");
                            }
                        }
                    }
                    c2 = this.nextNonWhitespace(true);
                    switch (c2) {
                        case 34: {
                            this.buffer.readByte();
                            this.peeked = 13;
                            return 13;
                        }
                        case 39: {
                            this.buffer.readByte();
                            this.checkLenient();
                            this.peeked = 12;
                            return 12;
                        }
                        case 125: {
                            if (peekStack != 5) {
                                this.buffer.readByte();
                                this.peeked = 2;
                                return 2;
                            }
                            throw this.syntaxError("Expected name");
                        }
                    }
                    this.checkLenient();
                    if (this.isLiteral((char)c2)) {
                        this.peeked = 14;
                        return 14;
                    }
                    throw this.syntaxError("Expected name");
                }
                if (peekStack != 4) break block46;
                this.stack[this.stackSize - 1] = 5;
                c = this.nextNonWhitespace(true);
                this.buffer.readByte();
                switch (c) {
                    case 58: {
                        break;
                    }
                    case 61: {
                        this.checkLenient();
                        if (this.source.request(1L) && this.buffer.getByte(0L) == 62) {
                            this.buffer.readByte();
                            break;
                        }
                        break block44;
                    }
                    default: {
                        throw this.syntaxError("Expected ':'");
                    }
                }
                break block44;
            }
            if (peekStack == 6) {
                this.stack[this.stackSize - 1] = 7;
            } else if (peekStack == 7) {
                c = this.nextNonWhitespace(false);
                if (c == -1) {
                    this.peeked = 17;
                    return 17;
                }
                this.checkLenient();
            } else if (peekStack == 8) {
                throw new IllegalStateException("JsonReader is closed");
            }
        }
        c = this.nextNonWhitespace(true);
        switch (c) {
            case 93: {
                if (peekStack == 1) {
                    this.buffer.readByte();
                    this.peeked = 4;
                    return 4;
                }
            }
            case 44: 
            case 59: {
                if (peekStack == 1 || peekStack == 2) {
                    this.checkLenient();
                    this.peeked = 7;
                    return 7;
                }
                throw this.syntaxError("Unexpected value");
            }
            case 39: {
                this.checkLenient();
                this.buffer.readByte();
                this.peeked = 8;
                return 8;
            }
            case 34: {
                this.buffer.readByte();
                this.peeked = 9;
                return 9;
            }
            case 91: {
                this.buffer.readByte();
                this.peeked = 3;
                return 3;
            }
            case 123: {
                this.buffer.readByte();
                this.peeked = 1;
                return 1;
            }
        }
        int result = this.peekKeyword();
        if (result != 0) {
            return result;
        }
        result = this.peekNumber();
        if (result != 0) {
            return result;
        }
        if (!this.isLiteral(this.buffer.getByte(0L))) {
            throw this.syntaxError("Expected value");
        }
        this.checkLenient();
        this.peeked = 10;
        return 10;
    }

    private int peekKeyword() throws IOException {
        int peeking;
        String keywordUpper;
        String keyword;
        byte c = this.buffer.getByte(0L);
        if (c == 116 || c == 84) {
            keyword = "true";
            keywordUpper = "TRUE";
            peeking = 5;
        } else if (c == 102 || c == 70) {
            keyword = "false";
            keywordUpper = "FALSE";
            peeking = 6;
        } else if (c == 110 || c == 78) {
            keyword = "null";
            keywordUpper = "NULL";
            peeking = 7;
        } else {
            return 0;
        }
        int length = keyword.length();
        for (int i = 1; i < length; ++i) {
            if (!this.source.request(i + 1)) {
                return 0;
            }
            c = this.buffer.getByte(i);
            if (c == keyword.charAt(i) || c == keywordUpper.charAt(i)) continue;
            return 0;
        }
        if (this.source.request(length + 1) && this.isLiteral(this.buffer.getByte(length))) {
            return 0;
        }
        this.buffer.skip(length);
        this.peeked = peeking;
        return this.peeked;
    }

    private int peekNumber() throws IOException {
        long value = 0L;
        boolean negative = false;
        boolean fitsInLong = true;
        int last = 0;
        int i = 0;
        block6: while (this.source.request(i + 1)) {
            byte c = this.buffer.getByte(i);
            switch (c) {
                case 45: {
                    if (last == 0) {
                        negative = true;
                        last = 1;
                        break;
                    }
                    if (last == 5) {
                        last = 6;
                        break;
                    }
                    return 0;
                }
                case 43: {
                    if (last == 5) {
                        last = 6;
                        break;
                    }
                    return 0;
                }
                case 69: 
                case 101: {
                    if (last == 2 || last == 4) {
                        last = 5;
                        break;
                    }
                    return 0;
                }
                case 46: {
                    if (last == 2) {
                        last = 3;
                        break;
                    }
                    return 0;
                }
                default: {
                    if (c < 48 || c > 57) {
                        if (!this.isLiteral(c)) break block6;
                        return 0;
                    }
                    if (last == 1 || last == 0) {
                        value = -(c - 48);
                        last = 2;
                        break;
                    }
                    if (last == 2) {
                        if (value == 0L) {
                            return 0;
                        }
                        long newValue = value * 10L - (long)(c - 48);
                        fitsInLong &= value > -922337203685477580L || value == -922337203685477580L && newValue < value;
                        value = newValue;
                        break;
                    }
                    if (last == 3) {
                        last = 4;
                        break;
                    }
                    if (last != 5 && last != 6) break;
                    last = 7;
                }
            }
            ++i;
        }
        if (last == 2 && fitsInLong && (value != Long.MIN_VALUE || negative)) {
            this.peekedLong = negative ? value : -value;
            this.buffer.skip(i);
            this.peeked = 15;
            return 15;
        }
        if (last == 2 || last == 4 || last == 7) {
            this.peekedNumberLength = i;
            this.peeked = 16;
            return 16;
        }
        return 0;
    }

    private boolean isLiteral(int c) throws IOException {
        switch (c) {
            case 35: 
            case 47: 
            case 59: 
            case 61: 
            case 92: {
                this.checkLenient();
            }
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 32: 
            case 44: 
            case 58: 
            case 91: 
            case 93: 
            case 123: 
            case 125: {
                return false;
            }
        }
        return true;
    }

    @Override
    public String nextName() throws IOException {
        String result;
        int p = this.peeked;
        if (p == 0) {
            p = this.doPeek();
        }
        if (p == 14) {
            result = this.nextUnquotedValue();
        } else if (p == 13) {
            result = this.nextQuotedValue(DOUBLE_QUOTE_OR_SLASH);
        } else if (p == 12) {
            result = this.nextQuotedValue(SINGLE_QUOTE_OR_SLASH);
        } else {
            throw new JsonDataException("Expected a name but was " + (Object)((Object)this.peek()) + " at path " + this.getPath());
        }
        this.peeked = 0;
        this.pathNames[this.stackSize - 1] = result;
        return result;
    }

    @Override
    int selectName(JsonReader.Options options) throws IOException {
        int p = this.peeked;
        if (p == 0) {
            p = this.doPeek();
        }
        if (p != 13) {
            return -1;
        }
        int result = this.source.select(options.doubleQuoteSuffix);
        if (result != -1) {
            this.peeked = 0;
            this.pathNames[this.stackSize - 1] = options.strings[result];
        }
        return result;
    }

    @Override
    public String nextString() throws IOException {
        String result;
        int p = this.peeked;
        if (p == 0) {
            p = this.doPeek();
        }
        if (p == 10) {
            result = this.nextUnquotedValue();
        } else if (p == 9) {
            result = this.nextQuotedValue(DOUBLE_QUOTE_OR_SLASH);
        } else if (p == 8) {
            result = this.nextQuotedValue(SINGLE_QUOTE_OR_SLASH);
        } else if (p == 11) {
            result = this.peekedString;
            this.peekedString = null;
        } else if (p == 15) {
            result = Long.toString(this.peekedLong);
        } else if (p == 16) {
            result = this.buffer.readUtf8(this.peekedNumberLength);
        } else {
            throw new JsonDataException("Expected a string but was " + (Object)((Object)this.peek()) + " at path " + this.getPath());
        }
        this.peeked = 0;
        int n = this.stackSize - 1;
        this.pathIndices[n] = this.pathIndices[n] + 1;
        return result;
    }

    @Override
    int selectString(JsonReader.Options options) throws IOException {
        int p = this.peeked;
        if (p == 0) {
            p = this.doPeek();
        }
        if (p != 9) {
            return -1;
        }
        int result = this.source.select(options.doubleQuoteSuffix);
        if (result != -1) {
            this.peeked = 0;
            int n = this.stackSize - 1;
            this.pathIndices[n] = this.pathIndices[n] + 1;
        }
        return result;
    }

    @Override
    public boolean nextBoolean() throws IOException {
        int p = this.peeked;
        if (p == 0) {
            p = this.doPeek();
        }
        if (p == 5) {
            this.peeked = 0;
            int n = this.stackSize - 1;
            this.pathIndices[n] = this.pathIndices[n] + 1;
            return true;
        }
        if (p == 6) {
            this.peeked = 0;
            int n = this.stackSize - 1;
            this.pathIndices[n] = this.pathIndices[n] + 1;
            return false;
        }
        throw new JsonDataException("Expected a boolean but was " + (Object)((Object)this.peek()) + " at path " + this.getPath());
    }

    @Override
    public <T> T nextNull() throws IOException {
        int p = this.peeked;
        if (p == 0) {
            p = this.doPeek();
        }
        if (p == 7) {
            this.peeked = 0;
            int n = this.stackSize - 1;
            this.pathIndices[n] = this.pathIndices[n] + 1;
            return null;
        }
        throw new JsonDataException("Expected null but was " + (Object)((Object)this.peek()) + " at path " + this.getPath());
    }

    @Override
    public double nextDouble() throws IOException {
        double result;
        int p = this.peeked;
        if (p == 0) {
            p = this.doPeek();
        }
        if (p == 15) {
            this.peeked = 0;
            int n = this.stackSize - 1;
            this.pathIndices[n] = this.pathIndices[n] + 1;
            return this.peekedLong;
        }
        if (p == 16) {
            this.peekedString = this.buffer.readUtf8(this.peekedNumberLength);
        } else if (p == 9) {
            this.peekedString = this.nextQuotedValue(DOUBLE_QUOTE_OR_SLASH);
        } else if (p == 8) {
            this.peekedString = this.nextQuotedValue(SINGLE_QUOTE_OR_SLASH);
        } else if (p == 10) {
            this.peekedString = this.nextUnquotedValue();
        } else if (p != 11) {
            throw new JsonDataException("Expected a double but was " + (Object)((Object)this.peek()) + " at path " + this.getPath());
        }
        this.peeked = 11;
        try {
            result = Double.parseDouble(this.peekedString);
        }
        catch (NumberFormatException e) {
            throw new JsonDataException("Expected a double but was " + this.peekedString + " at path " + this.getPath());
        }
        if (!this.lenient && (Double.isNaN(result) || Double.isInfinite(result))) {
            throw new IOException("JSON forbids NaN and infinities: " + result + " at path " + this.getPath());
        }
        this.peekedString = null;
        this.peeked = 0;
        int n = this.stackSize - 1;
        this.pathIndices[n] = this.pathIndices[n] + 1;
        return result;
    }

    @Override
    public long nextLong() throws IOException {
        double asDouble;
        int p = this.peeked;
        if (p == 0) {
            p = this.doPeek();
        }
        if (p == 15) {
            this.peeked = 0;
            int n = this.stackSize - 1;
            this.pathIndices[n] = this.pathIndices[n] + 1;
            return this.peekedLong;
        }
        if (p == 16) {
            this.peekedString = this.buffer.readUtf8(this.peekedNumberLength);
        } else if (p == 9 || p == 8) {
            this.peekedString = p == 9 ? this.nextQuotedValue(DOUBLE_QUOTE_OR_SLASH) : this.nextQuotedValue(SINGLE_QUOTE_OR_SLASH);
            try {
                long result = Long.parseLong(this.peekedString);
                this.peeked = 0;
                int n = this.stackSize - 1;
                this.pathIndices[n] = this.pathIndices[n] + 1;
                return result;
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (p != 11) {
            throw new JsonDataException("Expected a long but was " + (Object)((Object)this.peek()) + " at path " + this.getPath());
        }
        this.peeked = 11;
        try {
            asDouble = Double.parseDouble(this.peekedString);
        }
        catch (NumberFormatException e) {
            throw new JsonDataException("Expected a long but was " + this.peekedString + " at path " + this.getPath());
        }
        long result = (long)asDouble;
        if ((double)result != asDouble) {
            throw new JsonDataException("Expected a long but was " + this.peekedString + " at path " + this.getPath());
        }
        this.peekedString = null;
        this.peeked = 0;
        int n = this.stackSize - 1;
        this.pathIndices[n] = this.pathIndices[n] + 1;
        return result;
    }

    private String nextQuotedValue(ByteString runTerminator) throws IOException {
        long index;
        StringBuilder builder = null;
        while (true) {
            if ((index = this.source.indexOfElement(runTerminator)) == -1L) {
                throw this.syntaxError("Unterminated string");
            }
            if (this.buffer.getByte(index) != 92) break;
            if (builder == null) {
                builder = new StringBuilder();
            }
            builder.append(this.buffer.readUtf8(index));
            this.buffer.readByte();
            builder.append(this.readEscapeCharacter());
        }
        if (builder == null) {
            String result = this.buffer.readUtf8(index);
            this.buffer.readByte();
            return result;
        }
        builder.append(this.buffer.readUtf8(index));
        this.buffer.readByte();
        return builder.toString();
    }

    private String nextUnquotedValue() throws IOException {
        long i = this.source.indexOfElement(UNQUOTED_STRING_TERMINALS);
        return i != -1L ? this.buffer.readUtf8(i) : this.buffer.readUtf8();
    }

    private void skipQuotedValue(ByteString runTerminator) throws IOException {
        long index;
        while (true) {
            if ((index = this.source.indexOfElement(runTerminator)) == -1L) {
                throw this.syntaxError("Unterminated string");
            }
            if (this.buffer.getByte(index) != 92) break;
            this.buffer.skip(index + 1L);
            this.readEscapeCharacter();
        }
        this.buffer.skip(index + 1L);
    }

    private void skipUnquotedValue() throws IOException {
        long i = this.source.indexOfElement(UNQUOTED_STRING_TERMINALS);
        this.buffer.skip(i != -1L ? i : this.buffer.size());
    }

    @Override
    public int nextInt() throws IOException {
        double asDouble;
        int p = this.peeked;
        if (p == 0) {
            p = this.doPeek();
        }
        if (p == 15) {
            int result = (int)this.peekedLong;
            if (this.peekedLong != (long)result) {
                throw new JsonDataException("Expected an int but was " + this.peekedLong + " at path " + this.getPath());
            }
            this.peeked = 0;
            int n = this.stackSize - 1;
            this.pathIndices[n] = this.pathIndices[n] + 1;
            return result;
        }
        if (p == 16) {
            this.peekedString = this.buffer.readUtf8(this.peekedNumberLength);
        } else if (p == 9 || p == 8) {
            this.peekedString = p == 9 ? this.nextQuotedValue(DOUBLE_QUOTE_OR_SLASH) : this.nextQuotedValue(SINGLE_QUOTE_OR_SLASH);
            try {
                int result = Integer.parseInt(this.peekedString);
                this.peeked = 0;
                int n = this.stackSize - 1;
                this.pathIndices[n] = this.pathIndices[n] + 1;
                return result;
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (p != 11) {
            throw new JsonDataException("Expected an int but was " + (Object)((Object)this.peek()) + " at path " + this.getPath());
        }
        this.peeked = 11;
        try {
            asDouble = Double.parseDouble(this.peekedString);
        }
        catch (NumberFormatException e) {
            throw new JsonDataException("Expected an int but was " + this.peekedString + " at path " + this.getPath());
        }
        int result = (int)asDouble;
        if ((double)result != asDouble) {
            throw new JsonDataException("Expected an int but was " + this.peekedString + " at path " + this.getPath());
        }
        this.peekedString = null;
        this.peeked = 0;
        int n = this.stackSize - 1;
        this.pathIndices[n] = this.pathIndices[n] + 1;
        return result;
    }

    @Override
    public void close() throws IOException {
        this.peeked = 0;
        this.stack[0] = 8;
        this.stackSize = 1;
        this.buffer.clear();
        this.source.close();
    }

    @Override
    public void skipValue() throws IOException {
        if (this.failOnUnknown) {
            throw new JsonDataException("Cannot skip unexpected " + (Object)((Object)this.peek()) + " at " + this.getPath());
        }
        int count = 0;
        do {
            int p;
            if ((p = this.peeked) == 0) {
                p = this.doPeek();
            }
            if (p == 3) {
                this.push(1);
                ++count;
            } else if (p == 1) {
                this.push(3);
                ++count;
            } else if (p == 4) {
                --this.stackSize;
                --count;
            } else if (p == 2) {
                --this.stackSize;
                --count;
            } else if (p == 14 || p == 10) {
                this.skipUnquotedValue();
            } else if (p == 9 || p == 13) {
                this.skipQuotedValue(DOUBLE_QUOTE_OR_SLASH);
            } else if (p == 8 || p == 12) {
                this.skipQuotedValue(SINGLE_QUOTE_OR_SLASH);
            } else if (p == 16) {
                this.buffer.skip(this.peekedNumberLength);
            }
            this.peeked = 0;
        } while (count != 0);
        int n = this.stackSize - 1;
        this.pathIndices[n] = this.pathIndices[n] + 1;
        this.pathNames[this.stackSize - 1] = "null";
    }

    private void push(int newTop) {
        if (this.stackSize == this.stack.length) {
            int[] newStack = new int[this.stackSize * 2];
            int[] newPathIndices = new int[this.stackSize * 2];
            String[] newPathNames = new String[this.stackSize * 2];
            System.arraycopy(this.stack, 0, newStack, 0, this.stackSize);
            System.arraycopy(this.pathIndices, 0, newPathIndices, 0, this.stackSize);
            System.arraycopy(this.pathNames, 0, newPathNames, 0, this.stackSize);
            this.stack = newStack;
            this.pathIndices = newPathIndices;
            this.pathNames = newPathNames;
        }
        this.stack[this.stackSize++] = newTop;
    }

    private int nextNonWhitespace(boolean throwOnEof) throws IOException {
        int p = 0;
        block4: while (this.source.request(p + 1)) {
            byte c;
            if ((c = this.buffer.getByte(p++)) == 10 || c == 32 || c == 13 || c == 9) continue;
            this.buffer.skip(p - 1);
            if (c == 47) {
                if (!this.source.request(2L)) {
                    return c;
                }
                this.checkLenient();
                byte peek = this.buffer.getByte(1L);
                switch (peek) {
                    case 42: {
                        this.buffer.readByte();
                        this.buffer.readByte();
                        if (!this.skipTo("*/")) {
                            throw this.syntaxError("Unterminated comment");
                        }
                        this.buffer.readByte();
                        this.buffer.readByte();
                        p = 0;
                        continue block4;
                    }
                    case 47: {
                        this.buffer.readByte();
                        this.buffer.readByte();
                        this.skipToEndOfLine();
                        p = 0;
                        continue block4;
                    }
                }
                return c;
            }
            if (c == 35) {
                this.checkLenient();
                this.skipToEndOfLine();
                p = 0;
                continue;
            }
            return c;
        }
        if (throwOnEof) {
            throw new EOFException("End of input");
        }
        return -1;
    }

    private void checkLenient() throws IOException {
        if (!this.lenient) {
            throw this.syntaxError("Use JsonReader.setLenient(true) to accept malformed JSON");
        }
    }

    private void skipToEndOfLine() throws IOException {
        long index = this.source.indexOfElement(LINEFEED_OR_CARRIAGE_RETURN);
        this.buffer.skip(index != -1L ? index + 1L : this.buffer.size());
    }

    private boolean skipTo(String toFind) throws IOException {
        block0: while (this.source.request(toFind.length())) {
            for (int c = 0; c < toFind.length(); ++c) {
                if (this.buffer.getByte(c) == toFind.charAt(c)) continue;
                this.buffer.readByte();
                continue block0;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        return "JsonReader(" + this.source + ")";
    }

    @Override
    public String getPath() {
        return JsonScope.getPath(this.stackSize, this.stack, this.pathNames, this.pathIndices);
    }

    private char readEscapeCharacter() throws IOException {
        if (!this.source.request(1L)) {
            throw this.syntaxError("Unterminated escape sequence");
        }
        byte escaped = this.buffer.readByte();
        switch (escaped) {
            case 117: {
                int i;
                if (!this.source.request(4L)) {
                    throw new EOFException("Unterminated escape sequence at path " + this.getPath());
                }
                char result = '\u0000';
                int end = i + 4;
                for (i = 0; i < end; ++i) {
                    byte c = this.buffer.getByte(i);
                    result = (char)(result << 4);
                    if (c >= 48 && c <= 57) {
                        result = (char)(result + (c - 48));
                        continue;
                    }
                    if (c >= 97 && c <= 102) {
                        result = (char)(result + (c - 97 + 10));
                        continue;
                    }
                    if (c >= 65 && c <= 70) {
                        result = (char)(result + (c - 65 + 10));
                        continue;
                    }
                    throw this.syntaxError("\\u" + this.buffer.readUtf8(4L));
                }
                this.buffer.skip(4L);
                return result;
            }
            case 116: {
                return '\t';
            }
            case 98: {
                return '\b';
            }
            case 110: {
                return '\n';
            }
            case 114: {
                return '\r';
            }
            case 102: {
                return '\f';
            }
        }
        return (char)escaped;
    }

    private IOException syntaxError(String message) throws IOException {
        throw new IOException(message + " at path " + this.getPath());
    }

    @Override
    void promoteNameToValue() throws IOException {
        if (this.hasNext()) {
            this.peekedString = this.nextName();
            this.peeked = 11;
        }
    }
}

