/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.java.influxdb.metrics.agent;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.management.ObjectName;
import net.thisptr.java.influxdb.metrics.agent.parser.Configuration;
import net.thisptr.java.influxdb.metrics.agent.parser.ConfigurationException;
import net.thisptr.java.influxdb.metrics.agent.parser.ConfigurationParser;
import net.thisptr.java.influxdb.reporter.shade.com.google.common.base.Splitter;
import net.thisptr.java.influxdb.reporter.shade.com.google.common.base.Strings;
import net.thisptr.java.influxdb.reporter.shade.com.google.common.net.HostAndPort;

public class JvmAgentConfig {
    public static final int DEFAULT_PORT = 8086;
    public static final int DEFAULT_INTERVAL = 30;
    public static final String DEFAULT_USER = "root";
    public static final String DEFAULT_PASSWORD = "root";
    public static final String DEFAULT_LOG_LEVEL = "INFO";
    public List<HostAndPort> servers;
    public int interval;
    public String database;
    public String user;
    public String password;
    public Map<String, String> tags;
    public String retention;
    public String logLevel;
    public String logPath;
    private Configuration.ResolvedConfiguration config;

    public Map<String, String> getConfig() {
        return this.config.properties;
    }

    public Map<String, String> getConfigForMetric(ObjectName name, String attribute) {
        HashMap<String, String> result = new HashMap<String, String>();
        this.config.matchers.forEach(matcher -> {
            if (!matcher.pattern.matches(name, attribute)) {
                return;
            }
            matcher.properties.forEach(property -> result.putIfAbsent(property.key, property.value));
        });
        this.config.properties.forEach((k, v) -> result.putIfAbsent((String)k, (String)v));
        return result;
    }

    private static JvmAgentConfig fromMap(Map<String, String> values) {
        Context context = new Context(values);
        String servers = context.getString("servers");
        if (Strings.isNullOrEmpty(servers)) {
            throw new ConfigurationException("servers must not be null or empty.");
        }
        List hostAndPorts = StreamSupport.stream(Splitter.on(",").trimResults().split(servers).spliterator(), false).map(server -> HostAndPort.fromString(server).withDefaultPort(8086)).collect(Collectors.toList());
        int interval = context.getInteger("interval", 30);
        if (interval <= 0) {
            throw new ConfigurationException("interval must be positive.");
        }
        String database = context.getString("database");
        if (Strings.isNullOrEmpty(database)) {
            throw new ConfigurationException("database must not be null or empty.");
        }
        String user = context.getString("user", "root");
        if (Strings.isNullOrEmpty(user)) {
            throw new ConfigurationException("user must not be null or empty.");
        }
        String password = context.getString("password", "root");
        String retention = context.getString("retention");
        Map<String, String> tags = context.getSubProperties("tags.");
        String logLevel = context.getString("log.level", DEFAULT_LOG_LEVEL);
        String logPath = context.getString("log.path");
        JvmAgentConfig config = new JvmAgentConfig();
        config.servers = hostAndPorts;
        config.interval = interval;
        config.database = database;
        config.user = user;
        config.password = password;
        config.tags = tags;
        config.retention = retention;
        config.logLevel = logLevel;
        config.logPath = logPath;
        return config;
    }

    public static JvmAgentConfig fromString(String str) {
        Configuration.ResolvedConfiguration conf = ConfigurationParser.parse(str).resolve();
        JvmAgentConfig config = JvmAgentConfig.fromMap(conf.properties);
        config.config = conf;
        return config;
    }

    public static class Context {
        private Map<String, String> values;

        public Context(Map<String, String> values) {
            this.values = new LinkedHashMap<String, String>(values);
        }

        public String getString(String key) {
            return this.values.get(key);
        }

        public int getInteger(String key, int defval) {
            String val = this.values.get(key);
            return val == null ? defval : Integer.parseInt(val);
        }

        public String getString(String key, String defval) {
            return this.values.getOrDefault(key, defval);
        }

        public Map<String, String> getSubProperties(String key) {
            LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
            this.values.forEach((k, v) -> {
                if (k.startsWith(key)) {
                    result.put(k.substring(key.length()), (String)v);
                }
            });
            return result;
        }
    }
}

