/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.java.influxdb.metrics.agent.template.resolvers;

import java.io.IOException;
import java.io.InputStreamReader;
import java.util.concurrent.TimeUnit;
import net.thisptr.flume.influxdb.reporter.shade.com.google.common.io.CharStreams;
import net.thisptr.flume.influxdb.reporter.shade.com.google.common.io.Closeables;
import net.thisptr.java.influxdb.metrics.agent.template.PlaceholderResolver;

public class ShellResolver
implements PlaceholderResolver {
    private static final int DEFAULT_TIMEOUT = 5;
    private int timeout;

    public ShellResolver() {
        this(5);
    }

    public ShellResolver(int timeout) {
        this.timeout = timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String resolveInternal(String expr) throws IOException, InterruptedException {
        Process p = Runtime.getRuntime().exec(expr);
        try {
            if (!p.waitFor(this.timeout, TimeUnit.SECONDS)) {
                p.destroyForcibly();
                throw new CommandTimeoutException(expr);
            }
            if (p.exitValue() != 0) {
                String stdout = CharStreams.toString(new InputStreamReader(p.getInputStream()));
                String stderr = CharStreams.toString(new InputStreamReader(p.getErrorStream()));
                throw new CommandExecutionException(expr, p.exitValue(), stdout, stderr);
            }
            String string = CharStreams.toString(new InputStreamReader(p.getInputStream())).trim().replace('\n', ' ');
            return string;
        }
        finally {
            Closeables.closeQuietly(p.getInputStream());
            Closeables.closeQuietly(p.getErrorStream());
            Closeables.close(p.getOutputStream(), true);
        }
    }

    @Override
    public String resolve(String expr) {
        try {
            return this.resolveInternal(expr);
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public static class CommandExecutionException
    extends RuntimeException {
        private static final long serialVersionUID = -4796891652175732414L;
        private String command;
        private int exitCode;
        private String outputText;
        private String errorText;

        public CommandExecutionException(String command, int exitCode, String outputText, String errorText) {
            this.command = command;
            this.exitCode = exitCode;
            this.outputText = outputText;
            this.errorText = errorText;
        }

        @Override
        public String getMessage() {
            return String.format("Command failed (exit code = %d): %s\nstdout:\n%s\nstderr:\n%s\n", this.exitCode, this.command, this.outputText, this.errorText);
        }
    }

    public static class CommandTimeoutException
    extends RuntimeException {
        private static final long serialVersionUID = -7775070005207287558L;
        private final String command;

        public CommandTimeoutException(String command) {
            this.command = command;
        }

        @Override
        public String getMessage() {
            return String.format("Command timed out: %s", this.command);
        }
    }
}

