/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.java.influxdb.metrics.agent.template.resolvers;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Arrays;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import net.thisptr.flume.influxdb.reporter.shade.com.google.common.base.Joiner;
import net.thisptr.java.influxdb.metrics.agent.template.PlaceholderResolver;

public class JmxResolver
implements PlaceholderResolver {
    private static final MBeanServer MBEANS = ManagementFactory.getPlatformMBeanServer();

    @Override
    public String resolve(String expr) {
        try {
            return this.resolveInternal(expr);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String resolveInternal(String expr) throws MalformedObjectNameException, NullPointerException, AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException {
        String[] names = expr.split(":");
        if (names.length < 3) {
            throw new IllegalArgumentException(expr);
        }
        String attribute = names[names.length - 1];
        String domainWithKeyProperties = String.join((CharSequence)":", Arrays.copyOfRange(names, 0, names.length - 1));
        ArrayList<String> values = new ArrayList<String>();
        for (ObjectInstance mbean : MBEANS.queryMBeans(ObjectName.getInstance(domainWithKeyProperties), null)) {
            values.add(MBEANS.getAttribute(mbean.getObjectName(), attribute).toString());
        }
        return Joiner.on(",").join(values);
    }
}

