/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.java.influxdb.metrics.agent.template;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.thisptr.java.influxdb.metrics.agent.template.PlaceholderResolver;
import net.thisptr.java.influxdb.metrics.agent.template.resolvers.JmxResolver;
import net.thisptr.java.influxdb.metrics.agent.template.resolvers.ShellResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplateRenderer {
    private static final Logger LOG = LoggerFactory.getLogger(TemplateRenderer.class);
    private static final Pattern PLACEHOLDER = Pattern.compile("\\$\\{\\s*([a-zA-Z_]+)\\s*\\|\\s*((\\\\\\}|[^}])+)\\s*\\}");
    private final Map<String, PlaceholderResolver> resolvers = new HashMap<String, PlaceholderResolver>();

    public TemplateRenderer() {
        this.resolvers.put("sh", new ShellResolver());
        this.resolvers.put("jmx", new JmxResolver());
    }

    public String render(String text) {
        StringBuffer result = new StringBuffer();
        Matcher m = PLACEHOLDER.matcher(text);
        while (m.find()) {
            String type = m.group(1).toLowerCase();
            String expr = m.group(2);
            PlaceholderResolver resolver = this.resolvers.get(type);
            if (resolver == null) {
                LOG.warn("Placeholder resolver '{}' does not exist: {}", (Object)type, (Object)m.group());
                m.appendReplacement(result, expr);
                continue;
            }
            try {
                String value = resolver.resolve(expr);
                m.appendReplacement(result, value);
            }
            catch (Exception e) {
                LOG.warn("Failed to resolve placeholder: {}", (Object)m.group(), (Object)e);
                m.appendReplacement(result, expr);
            }
        }
        m.appendTail(result);
        return result.toString();
    }
}

