/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.java.influxdb.metrics.agent.parser;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.management.ObjectName;
import net.thisptr.java.influxdb.metrics.agent.parser.ConfigurationException;
import net.thisptr.java.influxdb.metrics.agent.parser.ConfigurationParser;

public class Configuration {
    public final List<Element> elements;

    public Configuration(List<Element> elements) {
        this.elements = Collections.unmodifiableList(new ArrayList<Element>(elements));
    }

    private static void recursiveResolveImports(List<Element> resolved, File cwd, List<Element> queue) throws Exception {
        for (Element element : queue) {
            if (!(element instanceof Import)) {
                resolved.add(element);
                continue;
            }
            String path = ((Import)element).path;
            File f = cwd == null ? new File(path) : new File(cwd, path);
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(f));
            Throwable throwable = null;
            try {
                Configuration sub = new ConfigurationParser(is).Start();
                Configuration.recursiveResolveImports(resolved, f.getParentFile(), sub.elements);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (is == null) continue;
                if (throwable != null) {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                ((InputStream)is).close();
            }
        }
    }

    public ResolvedConfiguration resolve() {
        try {
            ArrayList<Element> resolved = new ArrayList<Element>();
            Configuration.recursiveResolveImports(resolved, null, this.elements);
            HashMap<String, String> properties = new HashMap<String, String>();
            resolved.forEach(element -> {
                if (!(element instanceof Property)) {
                    return;
                }
                Property property = (Property)element;
                properties.putIfAbsent(property.key, property.value);
            });
            ArrayList<MatcherBlock> matchers = new ArrayList<MatcherBlock>();
            resolved.forEach(element -> {
                if (!(element instanceof MatcherBlock)) {
                    return;
                }
                MatcherBlock matcher = (MatcherBlock)element;
                matchers.add(matcher);
            });
            return new ResolvedConfiguration(properties, matchers);
        }
        catch (Throwable th) {
            throw new ConfigurationException(th);
        }
    }

    public static class ResolvedConfiguration {
        public final Map<String, String> properties;
        public final List<MatcherBlock> matchers;

        public ResolvedConfiguration(Map<String, String> properties, List<MatcherBlock> matchers) {
            this.properties = Collections.unmodifiableMap(new HashMap<String, String>(properties));
            this.matchers = Collections.unmodifiableList(new ArrayList<MatcherBlock>(matchers));
        }
    }

    public static class Import
    implements Element {
        public final String path;

        public Import(String path) {
            this.path = path;
        }
    }

    public static interface Element {
    }

    public static class MatcherBlock
    implements Element {
        public final MetricPattern pattern;
        public final List<Property> properties;

        public MatcherBlock(MetricPattern pattern, List<Property> properties) {
            this.pattern = pattern;
            this.properties = Collections.unmodifiableList(new ArrayList<Property>(properties));
        }
    }

    public static class MetricPattern {
        public final Pattern domain;
        public final Map<String, Pattern> keys;
        public final Pattern attribute;

        public MetricPattern(String domain, Map<String, String> keys, String attribute) {
            this.domain = domain != null ? Pattern.compile(domain) : null;
            LinkedHashMap tmp = new LinkedHashMap();
            keys.forEach((k, v) -> tmp.put(k, Pattern.compile(v)));
            this.keys = Collections.unmodifiableMap(tmp);
            this.attribute = attribute != null ? Pattern.compile(attribute) : null;
        }

        public boolean matches(ObjectName name, String attribute) {
            if (this.domain != null && !this.domain.matcher(name.getDomain()).matches()) {
                return false;
            }
            Hashtable<String, String> target = name.getKeyPropertyList();
            for (Map.Entry<String, Pattern> patternEntry : this.keys.entrySet()) {
                String targetValue = (String)target.get(patternEntry.getKey());
                if (targetValue != null && patternEntry.getValue().matcher(targetValue).matches()) continue;
                return false;
            }
            return this.attribute == null || attribute != null && this.attribute.matcher(attribute).matches();
        }
    }

    public static class Property
    implements Element {
        public final String key;
        public final String value;

        public Property(String key, String value) {
            this.key = key;
            this.value = value;
        }
    }
}

