/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.flume.influxdb.reporter.shade.org.influxdb.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.thisptr.flume.influxdb.reporter.shade.com.google.common.base.Preconditions;
import net.thisptr.flume.influxdb.reporter.shade.com.google.common.collect.Maps;
import net.thisptr.flume.influxdb.reporter.shade.org.influxdb.InfluxDB;
import net.thisptr.flume.influxdb.reporter.shade.org.influxdb.dto.BatchPoints;
import net.thisptr.flume.influxdb.reporter.shade.org.influxdb.dto.Point;
import net.thisptr.flume.influxdb.reporter.shade.org.influxdb.impl.InfluxDBImpl;

public class BatchProcessor {
    private static final Logger logger = Logger.getLogger(BatchProcessor.class.getName());
    protected final BlockingQueue<BatchEntry> queue = new LinkedBlockingQueue<BatchEntry>();
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    final InfluxDBImpl influxDB;
    final int actions;
    private final TimeUnit flushIntervalUnit;
    private final int flushInterval;

    public static Builder builder(InfluxDB influxDB) {
        return new Builder(influxDB);
    }

    BatchProcessor(InfluxDBImpl influxDB, int actions, TimeUnit flushIntervalUnit, int flushInterval) {
        this.influxDB = influxDB;
        this.actions = actions;
        this.flushIntervalUnit = flushIntervalUnit;
        this.flushInterval = flushInterval;
        this.scheduler.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                BatchProcessor.this.write();
            }
        }, this.flushInterval, this.flushInterval, this.flushIntervalUnit);
    }

    void write() {
        try {
            if (this.queue.isEmpty()) {
                return;
            }
            HashMap<String, BatchPoints> databaseToBatchPoints = Maps.newHashMap();
            ArrayList batchEntries = new ArrayList(this.queue.size());
            this.queue.drainTo(batchEntries);
            for (BatchEntry batchEntry : batchEntries) {
                String dbName = batchEntry.getDb();
                if (!databaseToBatchPoints.containsKey(dbName)) {
                    BatchPoints batchPoints = BatchPoints.database(dbName).retentionPolicy(batchEntry.getRp()).build();
                    databaseToBatchPoints.put(dbName, batchPoints);
                }
                Point point = batchEntry.getPoint();
                ((BatchPoints)databaseToBatchPoints.get(dbName)).point(point);
            }
            for (BatchPoints batchPoints : databaseToBatchPoints.values()) {
                this.influxDB.write(batchPoints);
            }
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, "Batch could not be sent. Data will be lost", t);
        }
    }

    void put(BatchEntry batchEntry) {
        this.queue.add(batchEntry);
        if (this.queue.size() >= this.actions) {
            this.write();
        }
    }

    void flush() {
        this.write();
        this.scheduler.shutdown();
    }

    static class BatchEntry {
        private final Point point;
        private final String db;
        private final String rp;

        public BatchEntry(Point point, String db, String rp) {
            this.point = point;
            this.db = db;
            this.rp = rp;
        }

        public Point getPoint() {
            return this.point;
        }

        public String getDb() {
            return this.db;
        }

        public String getRp() {
            return this.rp;
        }
    }

    public static final class Builder {
        private final InfluxDBImpl influxDB;
        private int actions;
        private TimeUnit flushIntervalUnit;
        private int flushInterval;

        public Builder(InfluxDB influxDB) {
            this.influxDB = (InfluxDBImpl)influxDB;
        }

        public Builder actions(int maxActions) {
            this.actions = maxActions;
            return this;
        }

        public Builder interval(int interval, TimeUnit unit) {
            this.flushInterval = interval;
            this.flushIntervalUnit = unit;
            return this;
        }

        public BatchProcessor build() {
            Preconditions.checkNotNull(this.actions, "actions may not be null");
            Preconditions.checkNotNull(this.flushInterval, "flushInterval may not be null");
            Preconditions.checkNotNull(this.flushIntervalUnit, "flushIntervalUnit may not be null");
            return new BatchProcessor(this.influxDB, this.actions, this.flushIntervalUnit, this.flushInterval);
        }
    }
}

