/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.flume.influxdb.reporter.shade.org.influxdb.dto;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.thisptr.flume.influxdb.reporter.shade.com.google.common.base.Preconditions;
import net.thisptr.flume.influxdb.reporter.shade.com.google.common.base.Strings;
import net.thisptr.flume.influxdb.reporter.shade.com.google.common.collect.Maps;
import net.thisptr.flume.influxdb.reporter.shade.com.google.common.collect.Ordering;
import net.thisptr.flume.influxdb.reporter.shade.com.google.common.escape.Escaper;
import net.thisptr.flume.influxdb.reporter.shade.com.google.common.escape.Escapers;

public class Point {
    private String measurement;
    private Map<String, String> tags;
    private Long time;
    private TimeUnit precision = TimeUnit.NANOSECONDS;
    private Map<String, Object> fields;
    private static final Escaper FIELD_ESCAPER = Escapers.builder().addEscape('\"', "\\\"").build();
    private static final Escaper KEY_ESCAPER = Escapers.builder().addEscape(' ', "\\ ").addEscape(',', "\\,").addEscape('=', "\\=").build();

    Point() {
    }

    public static Builder measurement(String measurement) {
        return new Builder(measurement);
    }

    void setMeasurement(String measurement) {
        this.measurement = measurement;
    }

    void setTime(Long time) {
        this.time = time;
    }

    void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    Map<String, String> getTags() {
        return this.tags;
    }

    void setPrecision(TimeUnit precision) {
        this.precision = precision;
    }

    void setFields(Map<String, Object> fields) {
        this.fields = fields;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Point [name=");
        builder.append(this.measurement);
        builder.append(", time=");
        builder.append(this.time);
        builder.append(", tags=");
        builder.append(this.tags);
        builder.append(", precision=");
        builder.append((Object)this.precision);
        builder.append(", fields=");
        builder.append(this.fields);
        builder.append("]");
        return builder.toString();
    }

    public String lineProtocol() {
        StringBuilder sb = new StringBuilder();
        sb.append(KEY_ESCAPER.escape(this.measurement));
        sb.append((CharSequence)this.concatenatedTags());
        sb.append((CharSequence)this.concatenateFields());
        sb.append((CharSequence)this.formatedTime());
        return sb.toString();
    }

    private StringBuilder concatenatedTags() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> tag : this.tags.entrySet()) {
            sb.append(",");
            sb.append(KEY_ESCAPER.escape(tag.getKey())).append("=").append(KEY_ESCAPER.escape(tag.getValue()));
        }
        sb.append(" ");
        return sb;
    }

    private StringBuilder concatenateFields() {
        StringBuilder sb = new StringBuilder();
        int fieldCount = this.fields.size();
        int loops = 0;
        NumberFormat numberFormat = NumberFormat.getInstance(Locale.ENGLISH);
        numberFormat.setMaximumFractionDigits(340);
        numberFormat.setGroupingUsed(false);
        numberFormat.setMinimumFractionDigits(1);
        for (Map.Entry<String, Object> field : this.fields.entrySet()) {
            ++loops;
            Object value = field.getValue();
            if (value == null) continue;
            sb.append(KEY_ESCAPER.escape(field.getKey())).append("=");
            if (value instanceof String) {
                String stringValue = (String)value;
                sb.append("\"").append(FIELD_ESCAPER.escape(stringValue)).append("\"");
            } else if (value instanceof Number) {
                if (value instanceof Double || value instanceof Float || value instanceof BigDecimal) {
                    sb.append(numberFormat.format(value));
                } else {
                    sb.append(value).append("i");
                }
            } else {
                sb.append(value);
            }
            if (loops >= fieldCount) continue;
            sb.append(",");
        }
        return sb;
    }

    private StringBuilder formatedTime() {
        StringBuilder sb = new StringBuilder();
        if (null == this.time) {
            this.time = System.nanoTime();
        }
        sb.append(" ").append(TimeUnit.NANOSECONDS.convert(this.time, this.precision));
        return sb;
    }

    public static final class Builder {
        private final String measurement;
        private final Map<String, String> tags = Maps.newTreeMap(Ordering.natural());
        private Long time;
        private TimeUnit precision = TimeUnit.NANOSECONDS;
        private final Map<String, Object> fields = Maps.newTreeMap(Ordering.natural());

        Builder(String measurement) {
            this.measurement = measurement;
        }

        public Builder tag(String tagName, String value) {
            Preconditions.checkArgument(tagName != null);
            Preconditions.checkArgument(value != null);
            this.tags.put(tagName, value);
            return this;
        }

        public Builder tag(Map<String, String> tagsToAdd) {
            for (Map.Entry<String, String> tag : tagsToAdd.entrySet()) {
                this.tag(tag.getKey(), tag.getValue());
            }
            return this;
        }

        @Deprecated
        public Builder field(String field, Object value) {
            if (value instanceof Number) {
                if (value instanceof Byte) {
                    value = ((Byte)value).doubleValue();
                }
                if (value instanceof Short) {
                    value = ((Short)value).doubleValue();
                }
                if (value instanceof Integer) {
                    value = ((Integer)value).doubleValue();
                }
                if (value instanceof Long) {
                    value = ((Long)value).doubleValue();
                }
                if (value instanceof BigInteger) {
                    value = ((BigInteger)value).doubleValue();
                }
            }
            this.fields.put(field, value);
            return this;
        }

        public Builder addField(String field, boolean value) {
            this.fields.put(field, value);
            return this;
        }

        public Builder addField(String field, long value) {
            this.fields.put(field, value);
            return this;
        }

        public Builder addField(String field, double value) {
            this.fields.put(field, value);
            return this;
        }

        public Builder addField(String field, Number value) {
            this.fields.put(field, value);
            return this;
        }

        public Builder addField(String field, String value) {
            if (value == null) {
                throw new IllegalArgumentException("Field value cannot be null");
            }
            this.fields.put(field, value);
            return this;
        }

        public Builder fields(Map<String, Object> fieldsToAdd) {
            this.fields.putAll(fieldsToAdd);
            return this;
        }

        public Builder time(long timeToSet, TimeUnit precisionToSet) {
            Preconditions.checkNotNull(precisionToSet, "Precision must be not null!");
            this.time = timeToSet;
            this.precision = precisionToSet;
            return this;
        }

        public Point build() {
            Preconditions.checkArgument(!Strings.isNullOrEmpty(this.measurement), "Point name must not be null or empty.");
            Preconditions.checkArgument(this.fields.size() > 0, "Point must have at least one field specified.");
            Point point = new Point();
            point.setFields(this.fields);
            point.setMeasurement(this.measurement);
            if (this.time != null) {
                point.setTime(this.time);
                point.setPrecision(this.precision);
            } else {
                point.setTime(System.currentTimeMillis());
                point.setPrecision(TimeUnit.MILLISECONDS);
            }
            point.setTags(this.tags);
            return point;
        }
    }
}

