/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.flume.influxdb.reporter.shade.org.influxdb.dto;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.thisptr.flume.influxdb.reporter.shade.com.google.common.base.Preconditions;
import net.thisptr.flume.influxdb.reporter.shade.com.google.common.base.Strings;
import net.thisptr.flume.influxdb.reporter.shade.com.google.common.collect.Lists;
import net.thisptr.flume.influxdb.reporter.shade.com.google.common.collect.Maps;
import net.thisptr.flume.influxdb.reporter.shade.com.google.common.collect.Ordering;
import net.thisptr.flume.influxdb.reporter.shade.org.influxdb.InfluxDB;
import net.thisptr.flume.influxdb.reporter.shade.org.influxdb.dto.Point;

public class BatchPoints {
    private String database;
    private String retentionPolicy;
    private Map<String, String> tags;
    private List<Point> points;
    private InfluxDB.ConsistencyLevel consistency;

    BatchPoints() {
    }

    public static Builder database(String database) {
        return new Builder(database);
    }

    public String getDatabase() {
        return this.database;
    }

    void setDatabase(String database) {
        this.database = database;
    }

    public String getRetentionPolicy() {
        return this.retentionPolicy;
    }

    void setRetentionPolicy(String retentionPolicy) {
        this.retentionPolicy = retentionPolicy;
    }

    public List<Point> getPoints() {
        return this.points;
    }

    void setPoints(List<Point> points) {
        this.points = points;
    }

    public BatchPoints point(Point point) {
        point.getTags().putAll(this.tags);
        this.points.add(point);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public InfluxDB.ConsistencyLevel getConsistency() {
        return this.consistency;
    }

    void setConsistency(InfluxDB.ConsistencyLevel consistency) {
        this.consistency = consistency;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("BatchPoints [database=");
        builder.append(this.database);
        builder.append(", retentionPolicy=");
        builder.append(this.retentionPolicy);
        builder.append(", tags=");
        builder.append(this.tags);
        builder.append(", points=");
        builder.append(this.points);
        builder.append("]");
        return builder.toString();
    }

    public String lineProtocol() {
        StringBuilder sb = new StringBuilder();
        for (Point point : this.points) {
            sb.append(point.lineProtocol()).append("\n");
        }
        return sb.toString();
    }

    public static final class Builder {
        private final String database;
        private String retentionPolicy;
        private final Map<String, String> tags = Maps.newTreeMap(Ordering.natural());
        private final List<Point> points = Lists.newArrayList();
        private InfluxDB.ConsistencyLevel consistency;

        Builder(String database) {
            this.database = database;
        }

        public Builder retentionPolicy(String policy) {
            this.retentionPolicy = policy;
            return this;
        }

        public Builder tag(String tagName, String value) {
            this.tags.put(tagName, value);
            return this;
        }

        public Builder point(Point pointToAdd) {
            this.points.add(pointToAdd);
            return this;
        }

        public Builder points(Point ... pointsToAdd) {
            this.points.addAll(Arrays.asList(pointsToAdd));
            return this;
        }

        public Builder consistency(InfluxDB.ConsistencyLevel consistencyLevel) {
            this.consistency = consistencyLevel;
            return this;
        }

        public BatchPoints build() {
            Preconditions.checkArgument(!Strings.isNullOrEmpty(this.database), "Database must not be null or empty.");
            BatchPoints batchPoints = new BatchPoints();
            batchPoints.setDatabase(this.database);
            for (Point point : this.points) {
                point.getTags().putAll(this.tags);
            }
            batchPoints.setPoints(this.points);
            batchPoints.setRetentionPolicy(this.retentionPolicy);
            batchPoints.setTags(this.tags);
            if (null == this.consistency) {
                this.consistency = InfluxDB.ConsistencyLevel.ONE;
            }
            batchPoints.setConsistency(this.consistency);
            return batchPoints;
        }
    }
}

