/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.java.influxdb.metrics.agent;

import java.util.ArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import net.thisptr.flume.influxdb.reporter.shade.com.google.common.net.HostAndPort;
import net.thisptr.flume.influxdb.reporter.shade.com.google.common.util.concurrent.ThreadFactoryBuilder;
import net.thisptr.flume.influxdb.reporter.shade.org.influxdb.InfluxDB;
import net.thisptr.flume.influxdb.reporter.shade.org.influxdb.InfluxDBFactory;
import net.thisptr.java.influxdb.metrics.agent.JvmAgent;
import net.thisptr.java.influxdb.metrics.agent.JvmAgentCommand;
import net.thisptr.java.influxdb.metrics.agent.JvmAgentConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JvmAgentService {
    private static final Logger LOG = LoggerFactory.getLogger(JvmAgent.class);
    private final JvmAgentConfig config;
    private volatile ScheduledExecutorService executor;
    private final AtomicReference<State> state = new AtomicReference<State>(State.STOPPED);
    private final AtomicLong epoch = new AtomicLong(0L);

    public JvmAgentService(JvmAgentConfig config) {
        this.config = config;
    }

    public void start() {
        if (!this.state.compareAndSet(State.STOPPED, State.STARTING)) {
            throw new IllegalStateException("InfluxDB Metrics Agent is expected to be in STOPPED state.");
        }
        LOG.info("Starting InfluxDB Metrics Agent...");
        try {
            ArrayList<InfluxDB> conns = new ArrayList<InfluxDB>(this.config.servers.size());
            for (HostAndPort server : this.config.servers) {
                try {
                    InfluxDB conn = InfluxDBFactory.connect("http://" + server, this.config.user, this.config.password);
                    conns.add(conn);
                }
                catch (Exception e) {
                    LOG.warn("Failed to connect to InfluxDB server {}.", (Object)server, (Object)e);
                }
            }
            this.executor = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("InfluxDB Metrics Agent %d").setDaemon(true).build());
            this.executor.scheduleWithFixedDelay(() -> {
                long epoch1;
                long epoch0 = this.epoch.get();
                if (epoch0 == (epoch1 = System.currentTimeMillis() / ((long)this.config.interval * 1000L))) {
                    return;
                }
                if (epoch0 != 0L && epoch1 - epoch0 != 1L) {
                    LOG.warn("Collecting and reporting metrics took too long. Skipped {} data points.", (Object)(epoch1 - epoch0 - 1L));
                }
                this.epoch.set(epoch1);
                new JvmAgentCommand(conns, this.config, epoch1 * ((long)this.config.interval * 1000L)).run();
            }, 0L, 100L, TimeUnit.MILLISECONDS);
            this.state.set(State.RUNNING);
        }
        catch (Throwable th) {
            LOG.error("Failed to start InfluxDB Metrics Agent.", th);
            this.state.set(State.STOPPED);
            throw th;
        }
    }

    public void stop() {
        if (!this.state.compareAndSet(State.RUNNING, State.STOPPING)) {
            throw new IllegalStateException("InfluxDB Metrics Agent is expected to be in RUNNING state.");
        }
        LOG.info("Stopping InfluxDB Metrics Agent...");
        try {
            this.executor.shutdown();
            while (!this.executor.isTerminated()) {
                try {
                    LOG.info("Waiting for InfluxDB Metrics Agent to stop...");
                    this.executor.awaitTermination(1L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    LOG.warn("Interrupted while waiting for InfluxDB Metrics Agent to shutdown.", (Throwable)e);
                    this.executor.shutdownNow();
                }
            }
        }
        finally {
            this.state.set(State.STOPPED);
        }
    }

    private static enum State {
        STARTING,
        RUNNING,
        STOPPING,
        STOPPED;

    }
}

