/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.java.influxdb.metrics.agent;

import java.lang.management.ManagementFactory;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import net.thisptr.flume.influxdb.reporter.shade.com.google.common.base.Splitter;
import net.thisptr.flume.influxdb.reporter.shade.com.google.common.base.Strings;
import net.thisptr.flume.influxdb.reporter.shade.com.google.common.collect.Lists;
import net.thisptr.flume.influxdb.reporter.shade.org.influxdb.InfluxDB;
import net.thisptr.flume.influxdb.reporter.shade.org.influxdb.dto.BatchPoints;
import net.thisptr.flume.influxdb.reporter.shade.org.influxdb.dto.Point;
import net.thisptr.java.influxdb.metrics.agent.JvmAgentConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JvmAgentCommand
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(JvmAgentCommand.class);
    private static final MBeanServer MBEANS = ManagementFactory.getPlatformMBeanServer();
    private final List<InfluxDB> conns;
    private final JvmAgentConfig config;
    private final long timestamp;
    public static final String CONFIG_KEY_NAMEKEYS = "namekeys";
    public static final String CONFIG_KEY_EXCLUDE = "exclude";

    public JvmAgentCommand(List<InfluxDB> conns, JvmAgentConfig config, long timestamp) {
        this.conns = conns;
        this.config = config;
        this.timestamp = timestamp;
    }

    private static List<String> configNamekeys(Map<String, String> config) {
        String namekeys = config.get(CONFIG_KEY_NAMEKEYS);
        if (Strings.isNullOrEmpty(namekeys)) {
            return Collections.emptyList();
        }
        return Lists.newArrayList(Splitter.on(",").trimResults().split(namekeys));
    }

    private static boolean configExclude(Map<String, String> config) {
        String exclude = config.get(CONFIG_KEY_EXCLUDE);
        if (Strings.isNullOrEmpty(exclude)) {
            return false;
        }
        return Boolean.parseBoolean(exclude);
    }

    @Override
    public void run() {
        LOG.debug("Collecting metrics to InfluxDB...");
        long startTime = System.currentTimeMillis();
        try {
            BatchPoints.Builder batchPoints = BatchPoints.database(this.config.database);
            if (!Strings.isNullOrEmpty(this.config.retention)) {
                batchPoints.retentionPolicy(this.config.retention);
            }
            this.config.tags.forEach((name, value) -> {
                if (Strings.isNullOrEmpty(value)) {
                    LOG.debug("Omitted a tag {}, as its value is empty.", name);
                    return;
                }
                batchPoints.tag((String)name, (String)value);
            });
            int batchPointSize = 0;
            for (ObjectInstance instance : MBEANS.queryMBeans(null, null)) {
                ObjectName oname = instance.getObjectName();
                Map<String, String> metricConfig = this.config.getConfigForMetric(oname, null);
                if (JvmAgentCommand.configExclude(metricConfig)) continue;
                String sep = ":";
                StringBuilder measurementName = new StringBuilder(oname.getDomain());
                Hashtable<String, String> measurementTags = oname.getKeyPropertyList();
                for (String measurementKey : JvmAgentCommand.configNamekeys(metricConfig)) {
                    String value2 = (String)measurementTags.remove(measurementKey);
                    if (value2 != null) {
                        measurementName.append(sep);
                        measurementName.append(measurementKey);
                        measurementName.append('=');
                        measurementName.append(value2);
                    }
                    sep = ",";
                }
                Point.Builder point = Point.measurement(measurementName.toString()).time(this.timestamp, TimeUnit.MILLISECONDS).tag(measurementTags);
                int fields = 0;
                for (MBeanAttributeInfo attr : MBEANS.getMBeanInfo(oname).getAttributes()) {
                    Object value3;
                    SupportedType type;
                    block19: {
                        Map<String, String> attrConfig = this.config.getConfigForMetric(oname, attr.getName());
                        if (JvmAgentCommand.configExclude(attrConfig)) continue;
                        String typeName = attr.getType();
                        if (typeName == null) {
                            LOG.debug("Ignored null type attribute {} in {}", (Object)attr.getName(), (Object)oname);
                            continue;
                        }
                        type = SupportedType.find(typeName);
                        if (type == null) {
                            LOG.debug("Ignored unsupported type attribute {} in {} (type = {})", new Object[]{attr.getName(), oname, attr.getType()});
                            continue;
                        }
                        try {
                            value3 = MBEANS.getAttribute(oname, attr.getName());
                            if (value3 == null) {
                            }
                            break block19;
                        }
                        catch (Exception e) {
                            LOG.debug("Failed to get value of the attribute " + attr.getName() + " in " + oname, (Throwable)e);
                        }
                        continue;
                    }
                    try {
                        fields += type.action.add(point, attr.getName(), value3);
                    }
                    catch (Exception e) {
                        LOG.debug("Failed to process value of attribute " + attr.getName() + " in " + oname, (Throwable)e);
                    }
                }
                if (fields == 0) continue;
                batchPoints.point(point.build());
                ++batchPointSize;
            }
            for (InfluxDB conn : this.conns) {
                try {
                    conn.createDatabase(this.config.database);
                }
                catch (Exception e) {
                    LOG.warn("Failed to create a database " + this.config.database + " on {}.", (Object)conn, (Object)e);
                    continue;
                }
                try {
                    conn.write(batchPoints.build());
                }
                catch (Exception e) {
                    LOG.warn("Sending metrics to {} failed.", (Object)conn, (Object)e);
                }
            }
            LOG.debug("Collected and sent {} batch points to InfluxDB in {} ms.", (Object)batchPointSize, (Object)(System.currentTimeMillis() - startTime));
        }
        catch (Throwable th) {
            LOG.error("Unknown error", th);
        }
    }

    public static enum SupportedType {
        NUMBER(Number.class, (builder, name, value) -> {
            builder.addField(name, (Number)value);
            return 1;
        }),
        STRING(String.class, (builder, name, value) -> {
            builder.addField(name, (String)value);
            return 1;
        }),
        DOUBLE(Double.class, (builder, name, value) -> {
            builder.addField(name, (Double)value);
            return 1;
        }),
        FLOAT(Float.class, (builder, name, value) -> {
            builder.addField(name, ((Float)value).doubleValue());
            return 1;
        }),
        LONG(Long.class, (builder, name, value) -> {
            builder.addField(name, (Long)value);
            return 1;
        }),
        INTEGER(Integer.class, (builder, name, value) -> {
            builder.addField(name, ((Integer)value).longValue());
            return 1;
        }),
        SHORT(Short.class, (builder, name, value) -> {
            builder.addField(name, ((Short)value).longValue());
            return 1;
        }),
        BYTE(Byte.class, (builder, name, value) -> {
            builder.addField(name, ((Byte)value).longValue());
            return 1;
        }),
        BOOLEAN(Boolean.class, (builder, name, value) -> {
            builder.addField(name, (Boolean)value);
            return 1;
        }),
        CHARACTER(Character.class, (builder, name, value) -> {
            builder.addField(name, ((Character)value).toString());
            return 1;
        }),
        COMPOSITE(CompositeData.class, (builder, name, composite) -> {
            int fields = 0;
            CompositeData data = (CompositeData)composite;
            for (String key : data.getCompositeType().keySet()) {
                Object value = data.get(key);
                if (value == null) continue;
                SupportedType stype = SupportedType.find(value.getClass());
                if (stype == null) {
                    LOG.debug("Composite {} contains value of unsupported type {}.", (Object)(name + "." + key), (Object)value.getClass().getName());
                    continue;
                }
                fields += stype.action.add(builder, name + "." + key, value);
            }
            return fields;
        });

        public final Class<?> clazz;
        public final Action action;

        private SupportedType(Class<?> clazz, Action action) {
            this.clazz = clazz;
            this.action = action;
        }

        public static SupportedType find(Class<?> clazz) {
            for (SupportedType type : SupportedType.values()) {
                if (!type.clazz.isAssignableFrom(clazz)) continue;
                return type;
            }
            return null;
        }

        public static SupportedType find(String className) {
            switch (className) {
                case "double": {
                    return DOUBLE;
                }
                case "float": {
                    return FLOAT;
                }
                case "long": {
                    return LONG;
                }
                case "short": {
                    return SHORT;
                }
                case "int": {
                    return INTEGER;
                }
                case "byte": {
                    return BYTE;
                }
                case "boolean": {
                    return BOOLEAN;
                }
                case "char": {
                    return CHARACTER;
                }
            }
            try {
                Class<?> clazz = Class.forName(className);
                return SupportedType.find(clazz);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }

        public static interface Action {
            public int add(Point.Builder var1, String var2, Object var3);
        }
    }
}

