/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.flume.influxdb.reporter.shade.retrofit.client;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.thisptr.flume.influxdb.reporter.shade.com.squareup.okhttp.Headers;
import net.thisptr.flume.influxdb.reporter.shade.com.squareup.okhttp.MediaType;
import net.thisptr.flume.influxdb.reporter.shade.com.squareup.okhttp.OkHttpClient;
import net.thisptr.flume.influxdb.reporter.shade.com.squareup.okhttp.Request;
import net.thisptr.flume.influxdb.reporter.shade.com.squareup.okhttp.RequestBody;
import net.thisptr.flume.influxdb.reporter.shade.com.squareup.okhttp.ResponseBody;
import net.thisptr.flume.influxdb.reporter.shade.okio.BufferedSink;
import net.thisptr.flume.influxdb.reporter.shade.retrofit.client.Client;
import net.thisptr.flume.influxdb.reporter.shade.retrofit.client.Header;
import net.thisptr.flume.influxdb.reporter.shade.retrofit.client.Request;
import net.thisptr.flume.influxdb.reporter.shade.retrofit.client.Response;
import net.thisptr.flume.influxdb.reporter.shade.retrofit.mime.TypedInput;
import net.thisptr.flume.influxdb.reporter.shade.retrofit.mime.TypedOutput;

public class OkClient
implements Client {
    private final OkHttpClient client;

    private static OkHttpClient generateDefaultOkHttp() {
        OkHttpClient client = new OkHttpClient();
        client.setConnectTimeout(15000L, TimeUnit.MILLISECONDS);
        client.setReadTimeout(20000L, TimeUnit.MILLISECONDS);
        return client;
    }

    public OkClient() {
        this(OkClient.generateDefaultOkHttp());
    }

    public OkClient(OkHttpClient client) {
        if (client == null) {
            throw new NullPointerException("client == null");
        }
        this.client = client;
    }

    @Override
    public Response execute(Request request) throws IOException {
        return OkClient.parseResponse(this.client.newCall(OkClient.createRequest(request)).execute());
    }

    static net.thisptr.flume.influxdb.reporter.shade.com.squareup.okhttp.Request createRequest(Request request) {
        Request.Builder builder = new Request.Builder().url(request.getUrl()).method(request.getMethod(), OkClient.createRequestBody(request.getBody()));
        List<Header> headers = request.getHeaders();
        int size = headers.size();
        for (int i = 0; i < size; ++i) {
            Header header = headers.get(i);
            String value = header.getValue();
            if (value == null) {
                value = "";
            }
            builder.addHeader(header.getName(), value);
        }
        return builder.build();
    }

    static Response parseResponse(net.thisptr.flume.influxdb.reporter.shade.com.squareup.okhttp.Response response) {
        return new Response(response.request().urlString(), response.code(), response.message(), OkClient.createHeaders(response.headers()), OkClient.createResponseBody(response.body()));
    }

    private static RequestBody createRequestBody(final TypedOutput body) {
        if (body == null) {
            return null;
        }
        final MediaType mediaType = MediaType.parse(body.mimeType());
        return new RequestBody(){

            @Override
            public MediaType contentType() {
                return mediaType;
            }

            @Override
            public void writeTo(BufferedSink sink) throws IOException {
                body.writeTo(sink.outputStream());
            }

            @Override
            public long contentLength() {
                return body.length();
            }
        };
    }

    private static TypedInput createResponseBody(final ResponseBody body) {
        if (body.contentLength() == 0L) {
            return null;
        }
        return new TypedInput(){

            @Override
            public String mimeType() {
                MediaType mediaType = body.contentType();
                return mediaType == null ? null : mediaType.toString();
            }

            @Override
            public long length() {
                return body.contentLength();
            }

            @Override
            public InputStream in() throws IOException {
                return body.byteStream();
            }
        };
    }

    private static List<Header> createHeaders(Headers headers) {
        int size = headers.size();
        ArrayList<Header> headerList = new ArrayList<Header>(size);
        for (int i = 0; i < size; ++i) {
            headerList.add(new Header(headers.name(i), headers.value(i)));
        }
        return headerList;
    }
}

