/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.flume.influxdb.reporter.shade.retrofit;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import net.thisptr.flume.influxdb.reporter.shade.retrofit.Callback;
import net.thisptr.flume.influxdb.reporter.shade.retrofit.CallbackRunnable;
import net.thisptr.flume.influxdb.reporter.shade.retrofit.Endpoint;
import net.thisptr.flume.influxdb.reporter.shade.retrofit.Endpoints;
import net.thisptr.flume.influxdb.reporter.shade.retrofit.ErrorHandler;
import net.thisptr.flume.influxdb.reporter.shade.retrofit.Platform;
import net.thisptr.flume.influxdb.reporter.shade.retrofit.Profiler;
import net.thisptr.flume.influxdb.reporter.shade.retrofit.RequestInterceptor;
import net.thisptr.flume.influxdb.reporter.shade.retrofit.RequestInterceptorTape;
import net.thisptr.flume.influxdb.reporter.shade.retrofit.ResponseWrapper;
import net.thisptr.flume.influxdb.reporter.shade.retrofit.RestMethodInfo;
import net.thisptr.flume.influxdb.reporter.shade.retrofit.RetrofitError;
import net.thisptr.flume.influxdb.reporter.shade.retrofit.RxSupport;
import net.thisptr.flume.influxdb.reporter.shade.retrofit.Utils;
import net.thisptr.flume.influxdb.reporter.shade.retrofit.client.Client;
import net.thisptr.flume.influxdb.reporter.shade.retrofit.client.Header;
import net.thisptr.flume.influxdb.reporter.shade.retrofit.client.Request;
import net.thisptr.flume.influxdb.reporter.shade.retrofit.client.Response;
import net.thisptr.flume.influxdb.reporter.shade.retrofit.converter.Converter;
import net.thisptr.flume.influxdb.reporter.shade.retrofit.mime.MimeUtil;
import net.thisptr.flume.influxdb.reporter.shade.retrofit.mime.TypedByteArray;
import net.thisptr.flume.influxdb.reporter.shade.retrofit.mime.TypedInput;
import net.thisptr.flume.influxdb.reporter.shade.retrofit.mime.TypedOutput;

public class RestAdapter {
    static final String THREAD_PREFIX = "Retrofit-";
    static final String IDLE_THREAD_NAME = "Retrofit-Idle";
    private final Map<Class<?>, Map<Method, RestMethodInfo>> serviceMethodInfoCache = new LinkedHashMap();
    final Endpoint server;
    final Executor httpExecutor;
    final Executor callbackExecutor;
    final RequestInterceptor requestInterceptor;
    final Converter converter;
    final Log log;
    final ErrorHandler errorHandler;
    private final Client.Provider clientProvider;
    private final Profiler profiler;
    private RxSupport rxSupport;
    volatile LogLevel logLevel;

    private RestAdapter(Endpoint server, Client.Provider clientProvider, Executor httpExecutor, Executor callbackExecutor, RequestInterceptor requestInterceptor, Converter converter, Profiler profiler, ErrorHandler errorHandler, Log log, LogLevel logLevel) {
        this.server = server;
        this.clientProvider = clientProvider;
        this.httpExecutor = httpExecutor;
        this.callbackExecutor = callbackExecutor;
        this.requestInterceptor = requestInterceptor;
        this.converter = converter;
        this.profiler = profiler;
        this.errorHandler = errorHandler;
        this.log = log;
        this.logLevel = logLevel;
    }

    public void setLogLevel(LogLevel loglevel) {
        if (this.logLevel == null) {
            throw new NullPointerException("Log level may not be null.");
        }
        this.logLevel = loglevel;
    }

    public LogLevel getLogLevel() {
        return this.logLevel;
    }

    public <T> T create(Class<T> service) {
        Utils.validateServiceClass(service);
        return (T)Proxy.newProxyInstance(service.getClassLoader(), new Class[]{service}, (InvocationHandler)new RestHandler(this.getMethodInfoCache(service)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<Method, RestMethodInfo> getMethodInfoCache(Class<?> service) {
        Map<Class<?>, Map<Method, RestMethodInfo>> map = this.serviceMethodInfoCache;
        synchronized (map) {
            Map<Method, RestMethodInfo> methodInfoCache = this.serviceMethodInfoCache.get(service);
            if (methodInfoCache == null) {
                methodInfoCache = new LinkedHashMap<Method, RestMethodInfo>();
                this.serviceMethodInfoCache.put(service, methodInfoCache);
            }
            return methodInfoCache;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static RestMethodInfo getMethodInfo(Map<Method, RestMethodInfo> cache, Method method) {
        Map<Method, RestMethodInfo> map = cache;
        synchronized (map) {
            RestMethodInfo methodInfo = cache.get(method);
            if (methodInfo == null) {
                methodInfo = new RestMethodInfo(method);
                cache.put(method, methodInfo);
            }
            return methodInfo;
        }
    }

    Request logAndReplaceRequest(String name, Request request, Object[] args) throws IOException {
        this.log.log(String.format("---> %s %s %s", name, request.getMethod(), request.getUrl()));
        if (this.logLevel.ordinal() >= LogLevel.HEADERS.ordinal()) {
            for (Header header : request.getHeaders()) {
                this.log.log(header.toString());
            }
            String bodySize = "no";
            TypedOutput body = request.getBody();
            if (body != null) {
                String bodyMime = body.mimeType();
                if (bodyMime != null) {
                    this.log.log("Content-Type: " + bodyMime);
                }
                long bodyLength = body.length();
                bodySize = bodyLength + "-byte";
                if (bodyLength != -1L) {
                    this.log.log("Content-Length: " + bodyLength);
                }
                if (this.logLevel.ordinal() >= LogLevel.FULL.ordinal()) {
                    if (!request.getHeaders().isEmpty()) {
                        this.log.log("");
                    }
                    if (!(body instanceof TypedByteArray)) {
                        request = Utils.readBodyToBytesIfNecessary(request);
                        body = request.getBody();
                    }
                    byte[] bodyBytes = ((TypedByteArray)body).getBytes();
                    String bodyCharset = MimeUtil.parseCharset(body.mimeType(), "UTF-8");
                    this.log.log(new String(bodyBytes, bodyCharset));
                } else if (this.logLevel.ordinal() >= LogLevel.HEADERS_AND_ARGS.ordinal()) {
                    if (!request.getHeaders().isEmpty()) {
                        this.log.log("---> REQUEST:");
                    }
                    for (int i = 0; i < args.length; ++i) {
                        this.log.log("#" + i + ": " + args[i]);
                    }
                }
            }
            this.log.log(String.format("---> END %s (%s body)", name, bodySize));
        }
        return request;
    }

    private Response logAndReplaceResponse(String url, Response response, long elapsedTime) throws IOException {
        this.log.log(String.format("<--- HTTP %s %s (%sms)", response.getStatus(), url, elapsedTime));
        if (this.logLevel.ordinal() >= LogLevel.HEADERS.ordinal()) {
            for (Header header : response.getHeaders()) {
                this.log.log(header.toString());
            }
            long bodySize = 0L;
            TypedInput body = response.getBody();
            if (body != null) {
                bodySize = body.length();
                if (this.logLevel.ordinal() >= LogLevel.FULL.ordinal()) {
                    if (!response.getHeaders().isEmpty()) {
                        this.log.log("");
                    }
                    if (!(body instanceof TypedByteArray)) {
                        response = Utils.readBodyToBytesIfNecessary(response);
                        body = response.getBody();
                    }
                    byte[] bodyBytes = ((TypedByteArray)body).getBytes();
                    bodySize = bodyBytes.length;
                    String bodyMime = body.mimeType();
                    String bodyCharset = MimeUtil.parseCharset(bodyMime, "UTF-8");
                    this.log.log(new String(bodyBytes, bodyCharset));
                }
            }
            this.log.log(String.format("<--- END HTTP (%s-byte body)", bodySize));
        }
        return response;
    }

    private void logResponseBody(TypedInput body, Object convert) {
        if (this.logLevel.ordinal() == LogLevel.HEADERS_AND_ARGS.ordinal()) {
            this.log.log("<--- BODY:");
            this.log.log(convert.toString());
        }
    }

    void logException(Throwable t, String url) {
        this.log.log(String.format("---- ERROR %s", url != null ? url : ""));
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter(sw));
        this.log.log(sw.toString());
        this.log.log("---- END ERROR");
    }

    private static Profiler.RequestInformation getRequestInfo(String serverUrl, RestMethodInfo methodDetails, Request request) {
        long contentLength = 0L;
        String contentType = null;
        TypedOutput body = request.getBody();
        if (body != null) {
            contentLength = body.length();
            contentType = body.mimeType();
        }
        return new Profiler.RequestInformation(methodDetails.requestMethod, serverUrl, methodDetails.requestUrl, contentLength, contentType);
    }

    static /* synthetic */ Profiler access$200(RestAdapter x0) {
        return x0.profiler;
    }

    static /* synthetic */ Client.Provider access$300(RestAdapter x0) {
        return x0.clientProvider;
    }

    static /* synthetic */ Profiler.RequestInformation access$400(String x0, RestMethodInfo x1, Request x2) {
        return RestAdapter.getRequestInfo(x0, x1, x2);
    }

    static /* synthetic */ Response access$500(RestAdapter x0, String x1, Response x2, long x3) throws IOException {
        return x0.logAndReplaceResponse(x1, x2, x3);
    }

    static /* synthetic */ void access$600(RestAdapter x0, TypedInput x1, Object x2) {
        x0.logResponseBody(x1, x2);
    }

    public static class Builder {
        private Endpoint endpoint;
        private Client.Provider clientProvider;
        private Executor httpExecutor;
        private Executor callbackExecutor;
        private RequestInterceptor requestInterceptor;
        private Converter converter;
        private Profiler profiler;
        private ErrorHandler errorHandler;
        private Log log;
        private LogLevel logLevel = LogLevel.NONE;

        public Builder setEndpoint(String endpoint) {
            if (endpoint == null || endpoint.trim().length() == 0) {
                throw new NullPointerException("Endpoint may not be blank.");
            }
            this.endpoint = Endpoints.newFixedEndpoint(endpoint);
            return this;
        }

        public Builder setEndpoint(Endpoint endpoint) {
            if (endpoint == null) {
                throw new NullPointerException("Endpoint may not be null.");
            }
            this.endpoint = endpoint;
            return this;
        }

        public Builder setClient(final Client client) {
            if (client == null) {
                throw new NullPointerException("Client may not be null.");
            }
            return this.setClient(new Client.Provider(){

                @Override
                public Client get() {
                    return client;
                }
            });
        }

        public Builder setClient(Client.Provider clientProvider) {
            if (clientProvider == null) {
                throw new NullPointerException("Client provider may not be null.");
            }
            this.clientProvider = clientProvider;
            return this;
        }

        public Builder setExecutors(Executor httpExecutor, Executor callbackExecutor) {
            if (httpExecutor == null) {
                throw new NullPointerException("HTTP executor may not be null.");
            }
            if (callbackExecutor == null) {
                callbackExecutor = new Utils.SynchronousExecutor();
            }
            this.httpExecutor = httpExecutor;
            this.callbackExecutor = callbackExecutor;
            return this;
        }

        public Builder setRequestInterceptor(RequestInterceptor requestInterceptor) {
            if (requestInterceptor == null) {
                throw new NullPointerException("Request interceptor may not be null.");
            }
            this.requestInterceptor = requestInterceptor;
            return this;
        }

        public Builder setConverter(Converter converter) {
            if (converter == null) {
                throw new NullPointerException("Converter may not be null.");
            }
            this.converter = converter;
            return this;
        }

        public Builder setProfiler(Profiler profiler) {
            if (profiler == null) {
                throw new NullPointerException("Profiler may not be null.");
            }
            this.profiler = profiler;
            return this;
        }

        public Builder setErrorHandler(ErrorHandler errorHandler) {
            if (errorHandler == null) {
                throw new NullPointerException("Error handler may not be null.");
            }
            this.errorHandler = errorHandler;
            return this;
        }

        public Builder setLog(Log log) {
            if (log == null) {
                throw new NullPointerException("Log may not be null.");
            }
            this.log = log;
            return this;
        }

        public Builder setLogLevel(LogLevel logLevel) {
            if (logLevel == null) {
                throw new NullPointerException("Log level may not be null.");
            }
            this.logLevel = logLevel;
            return this;
        }

        public RestAdapter build() {
            if (this.endpoint == null) {
                throw new IllegalArgumentException("Endpoint may not be null.");
            }
            this.ensureSaneDefaults();
            return new RestAdapter(this.endpoint, this.clientProvider, this.httpExecutor, this.callbackExecutor, this.requestInterceptor, this.converter, this.profiler, this.errorHandler, this.log, this.logLevel);
        }

        private void ensureSaneDefaults() {
            if (this.converter == null) {
                this.converter = Platform.get().defaultConverter();
            }
            if (this.clientProvider == null) {
                this.clientProvider = Platform.get().defaultClient();
            }
            if (this.httpExecutor == null) {
                this.httpExecutor = Platform.get().defaultHttpExecutor();
            }
            if (this.callbackExecutor == null) {
                this.callbackExecutor = Platform.get().defaultCallbackExecutor();
            }
            if (this.errorHandler == null) {
                this.errorHandler = ErrorHandler.DEFAULT;
            }
            if (this.log == null) {
                this.log = Platform.get().defaultLog();
            }
            if (this.requestInterceptor == null) {
                this.requestInterceptor = RequestInterceptor.NONE;
            }
        }
    }

    private class RestHandler
    implements InvocationHandler {
        private final Map<Method, RestMethodInfo> methodDetailsCache;

        RestHandler(Map<Method, RestMethodInfo> methodDetailsCache) {
            this.methodDetailsCache = methodDetailsCache;
        }

        @Override
        public Object invoke(Object proxy, Method method, final Object[] args) throws Throwable {
            if (method.getDeclaringClass() == Object.class) {
                return method.invoke((Object)this, args);
            }
            final RestMethodInfo methodInfo = RestAdapter.getMethodInfo(this.methodDetailsCache, method);
            if (methodInfo.isSynchronous) {
                try {
                    return this.invokeRequest(RestAdapter.this.requestInterceptor, methodInfo, args);
                }
                catch (RetrofitError error) {
                    Throwable newError = RestAdapter.this.errorHandler.handleError(error);
                    if (newError == null) {
                        throw new IllegalStateException("Error handler returned null for wrapped exception.", error);
                    }
                    throw newError;
                }
            }
            if (RestAdapter.this.httpExecutor == null || RestAdapter.this.callbackExecutor == null) {
                throw new IllegalStateException("Asynchronous invocation requires calling setExecutors.");
            }
            if (methodInfo.isObservable) {
                if (RestAdapter.this.rxSupport == null) {
                    if (Platform.HAS_RX_JAVA) {
                        RestAdapter.this.rxSupport = new RxSupport(RestAdapter.this.httpExecutor, RestAdapter.this.errorHandler, RestAdapter.this.requestInterceptor);
                    } else {
                        throw new IllegalStateException("Observable method found but no RxJava on classpath.");
                    }
                }
                return RestAdapter.this.rxSupport.createRequestObservable(new RxSupport.Invoker(){

                    @Override
                    public ResponseWrapper invoke(RequestInterceptor requestInterceptor) {
                        return (ResponseWrapper)RestHandler.this.invokeRequest(requestInterceptor, methodInfo, args);
                    }
                });
            }
            final RequestInterceptorTape interceptorTape = new RequestInterceptorTape();
            RestAdapter.this.requestInterceptor.intercept(interceptorTape);
            Callback callback = (Callback)args[args.length - 1];
            RestAdapter.this.httpExecutor.execute(new CallbackRunnable(callback, RestAdapter.this.callbackExecutor, RestAdapter.this.errorHandler){

                @Override
                public ResponseWrapper obtainResponse() {
                    return (ResponseWrapper)RestHandler.this.invokeRequest(interceptorTape, methodInfo, args);
                }
            });
            return null;
        }

        /*
         * Exception decompiling
         */
        private Object invokeRequest(RequestInterceptor requestInterceptor, RestMethodInfo methodInfo, Object[] args) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[CATCHBLOCK]], but top level block is 8[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    public static enum LogLevel {
        NONE,
        BASIC,
        HEADERS,
        HEADERS_AND_ARGS,
        FULL;


        public boolean log() {
            return this != NONE;
        }
    }

    public static interface Log {
        public static final Log NONE = new Log(){

            @Override
            public void log(String message) {
            }
        };

        public void log(String var1);
    }
}

