/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.flume.influxdb.reporter.shade.retrofit;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.thisptr.flume.influxdb.reporter.shade.retrofit.RequestInterceptor;
import net.thisptr.flume.influxdb.reporter.shade.retrofit.RestMethodInfo;
import net.thisptr.flume.influxdb.reporter.shade.retrofit.client.Header;
import net.thisptr.flume.influxdb.reporter.shade.retrofit.client.Request;
import net.thisptr.flume.influxdb.reporter.shade.retrofit.converter.Converter;
import net.thisptr.flume.influxdb.reporter.shade.retrofit.http.Body;
import net.thisptr.flume.influxdb.reporter.shade.retrofit.http.EncodedPath;
import net.thisptr.flume.influxdb.reporter.shade.retrofit.http.EncodedQuery;
import net.thisptr.flume.influxdb.reporter.shade.retrofit.http.EncodedQueryMap;
import net.thisptr.flume.influxdb.reporter.shade.retrofit.http.Field;
import net.thisptr.flume.influxdb.reporter.shade.retrofit.http.FieldMap;
import net.thisptr.flume.influxdb.reporter.shade.retrofit.http.Part;
import net.thisptr.flume.influxdb.reporter.shade.retrofit.http.PartMap;
import net.thisptr.flume.influxdb.reporter.shade.retrofit.http.Path;
import net.thisptr.flume.influxdb.reporter.shade.retrofit.http.Query;
import net.thisptr.flume.influxdb.reporter.shade.retrofit.http.QueryMap;
import net.thisptr.flume.influxdb.reporter.shade.retrofit.mime.FormUrlEncodedTypedOutput;
import net.thisptr.flume.influxdb.reporter.shade.retrofit.mime.MultipartTypedOutput;
import net.thisptr.flume.influxdb.reporter.shade.retrofit.mime.TypedOutput;
import net.thisptr.flume.influxdb.reporter.shade.retrofit.mime.TypedString;

final class RequestBuilder
implements RequestInterceptor.RequestFacade {
    private final Converter converter;
    private final Annotation[] paramAnnotations;
    private final String requestMethod;
    private final boolean isSynchronous;
    private final boolean isObservable;
    private final String apiUrl;
    private final FormUrlEncodedTypedOutput formBody;
    private final MultipartTypedOutput multipartBody;
    private TypedOutput body;
    private String relativeUrl;
    private StringBuilder queryParams;
    private List<Header> headers;
    private String contentTypeHeader;

    RequestBuilder(String apiUrl, RestMethodInfo methodInfo, Converter converter) {
        this.apiUrl = apiUrl;
        this.converter = converter;
        this.paramAnnotations = methodInfo.requestParamAnnotations;
        this.requestMethod = methodInfo.requestMethod;
        this.isSynchronous = methodInfo.isSynchronous;
        this.isObservable = methodInfo.isObservable;
        if (methodInfo.headers != null) {
            this.headers = new ArrayList<Header>(methodInfo.headers);
        }
        this.contentTypeHeader = methodInfo.contentTypeHeader;
        this.relativeUrl = methodInfo.requestUrl;
        String requestQuery = methodInfo.requestQuery;
        if (requestQuery != null) {
            this.queryParams = new StringBuilder().append('?').append(requestQuery);
        }
        switch (methodInfo.requestType) {
            case FORM_URL_ENCODED: {
                this.formBody = new FormUrlEncodedTypedOutput();
                this.multipartBody = null;
                this.body = this.formBody;
                break;
            }
            case MULTIPART: {
                this.formBody = null;
                this.multipartBody = new MultipartTypedOutput();
                this.body = this.multipartBody;
                break;
            }
            case SIMPLE: {
                this.formBody = null;
                this.multipartBody = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown request type: " + (Object)((Object)methodInfo.requestType));
            }
        }
    }

    @Override
    public void addHeader(String name, String value) {
        if (name == null) {
            throw new IllegalArgumentException("Header name must not be null.");
        }
        if ("Content-Type".equalsIgnoreCase(name)) {
            this.contentTypeHeader = value;
            return;
        }
        List<Header> headers = this.headers;
        if (headers == null) {
            this.headers = headers = new ArrayList<Header>(2);
        }
        headers.add(new Header(name, value));
    }

    @Override
    public void addPathParam(String name, String value) {
        this.addPathParam(name, value, true);
    }

    @Override
    public void addEncodedPathParam(String name, String value) {
        this.addPathParam(name, value, false);
    }

    private void addPathParam(String name, String value, boolean urlEncodeValue) {
        if (name == null) {
            throw new IllegalArgumentException("Path replacement name must not be null.");
        }
        if (value == null) {
            throw new IllegalArgumentException("Path replacement \"" + name + "\" value must not be null.");
        }
        try {
            if (urlEncodeValue) {
                String encodedValue = URLEncoder.encode(String.valueOf(value), "UTF-8");
                encodedValue = encodedValue.replace("+", "%20");
                this.relativeUrl = this.relativeUrl.replace("{" + name + "}", encodedValue);
            } else {
                this.relativeUrl = this.relativeUrl.replace("{" + name + "}", String.valueOf(value));
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Unable to convert path parameter \"" + name + "\" value to UTF-8:" + value, e);
        }
    }

    @Override
    public void addQueryParam(String name, String value) {
        this.addQueryParam(name, value, false, true);
    }

    @Override
    public void addEncodedQueryParam(String name, String value) {
        this.addQueryParam(name, value, false, false);
    }

    private void addQueryParam(String name, Object value, boolean encodeName, boolean encodeValue) {
        if (value instanceof Iterable) {
            for (Object iterableValue : (Iterable)value) {
                if (iterableValue == null) continue;
                this.addQueryParam(name, iterableValue.toString(), encodeName, encodeValue);
            }
        } else if (value.getClass().isArray()) {
            int arrayLength = Array.getLength(value);
            for (int x = 0; x < arrayLength; ++x) {
                Object arrayValue = Array.get(value, x);
                if (arrayValue == null) continue;
                this.addQueryParam(name, arrayValue.toString(), encodeName, encodeValue);
            }
        } else {
            this.addQueryParam(name, value.toString(), encodeName, encodeValue);
        }
    }

    private void addQueryParam(String name, String value, boolean encodeName, boolean encodeValue) {
        if (name == null) {
            throw new IllegalArgumentException("Query param name must not be null.");
        }
        if (value == null) {
            throw new IllegalArgumentException("Query param \"" + name + "\" value must not be null.");
        }
        try {
            StringBuilder queryParams = this.queryParams;
            if (queryParams == null) {
                this.queryParams = queryParams = new StringBuilder();
            }
            queryParams.append(queryParams.length() > 0 ? (char)'&' : '?');
            if (encodeName) {
                name = URLEncoder.encode(name, "UTF-8");
            }
            if (encodeValue) {
                value = URLEncoder.encode(value, "UTF-8");
            }
            queryParams.append(name).append('=').append(value);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Unable to convert query parameter \"" + name + "\" value to UTF-8: " + value, e);
        }
    }

    private void addQueryParamMap(int parameterNumber, Map<?, ?> map, boolean encodeNames, boolean encodeValues) {
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            Object entryKey = entry.getKey();
            if (entryKey == null) {
                throw new IllegalArgumentException("Parameter #" + (parameterNumber + 1) + " query map contained null key.");
            }
            Object entryValue = entry.getValue();
            if (entryValue == null) continue;
            this.addQueryParam(entryKey.toString(), entryValue.toString(), encodeNames, encodeValues);
        }
    }

    void setArguments(Object[] args) {
        if (args == null) {
            return;
        }
        int count = args.length;
        if (!this.isSynchronous && !this.isObservable) {
            --count;
        }
        for (int i = 0; i < count; ++i) {
            Annotation query;
            String name;
            Object value = args[i];
            Annotation annotation = this.paramAnnotations[i];
            Class<? extends Annotation> annotationType = annotation.annotationType();
            if (annotationType == Path.class) {
                Path path = (Path)annotation;
                String name2 = path.value();
                if (value == null) {
                    throw new IllegalArgumentException("Path parameter \"" + name2 + "\" value must not be null.");
                }
                this.addPathParam(name2, value.toString(), path.encode());
                continue;
            }
            if (annotationType == EncodedPath.class) {
                name = ((EncodedPath)annotation).value();
                if (value == null) {
                    throw new IllegalArgumentException("Path parameter \"" + name + "\" value must not be null.");
                }
                this.addPathParam(name, value.toString(), false);
                continue;
            }
            if (annotationType == Query.class) {
                if (value == null) continue;
                query = (Query)annotation;
                this.addQueryParam(query.value(), value, query.encodeName(), query.encodeValue());
                continue;
            }
            if (annotationType == EncodedQuery.class) {
                if (value == null) continue;
                query = (EncodedQuery)annotation;
                this.addQueryParam(query.value(), value, false, false);
                continue;
            }
            if (annotationType == QueryMap.class) {
                if (value == null) continue;
                QueryMap queryMap = (QueryMap)annotation;
                this.addQueryParamMap(i, (Map)value, queryMap.encodeNames(), queryMap.encodeValues());
                continue;
            }
            if (annotationType == EncodedQueryMap.class) {
                if (value == null) continue;
                this.addQueryParamMap(i, (Map)value, false, false);
                continue;
            }
            if (annotationType == net.thisptr.flume.influxdb.reporter.shade.retrofit.http.Header.class) {
                if (value == null) continue;
                name = ((net.thisptr.flume.influxdb.reporter.shade.retrofit.http.Header)annotation).value();
                if (value instanceof Iterable) {
                    for (Object iterableValue : (Iterable)value) {
                        if (iterableValue == null) continue;
                        this.addHeader(name, iterableValue.toString());
                    }
                    continue;
                }
                if (value.getClass().isArray()) {
                    int arrayLength = Array.getLength(value);
                    for (int x = 0; x < arrayLength; ++x) {
                        Object arrayValue = Array.get(value, x);
                        if (arrayValue == null) continue;
                        this.addHeader(name, arrayValue.toString());
                    }
                    continue;
                }
                this.addHeader(name, value.toString());
                continue;
            }
            if (annotationType == Field.class) {
                if (value == null) continue;
                Field field = (Field)annotation;
                String name3 = field.value();
                boolean encodeName = field.encodeName();
                boolean encodeValue = field.encodeValue();
                if (value instanceof Iterable) {
                    for (Object iterableValue : (Iterable)value) {
                        if (iterableValue == null) continue;
                        this.formBody.addField(name3, encodeName, iterableValue.toString(), encodeValue);
                    }
                    continue;
                }
                if (value.getClass().isArray()) {
                    int arrayLength = Array.getLength(value);
                    for (int x = 0; x < arrayLength; ++x) {
                        Object arrayValue = Array.get(value, x);
                        if (arrayValue == null) continue;
                        this.formBody.addField(name3, encodeName, arrayValue.toString(), encodeValue);
                    }
                    continue;
                }
                this.formBody.addField(name3, encodeName, value.toString(), encodeValue);
                continue;
            }
            if (annotationType == FieldMap.class) {
                if (value == null) continue;
                FieldMap fieldMap = (FieldMap)annotation;
                boolean encodeNames = fieldMap.encodeNames();
                boolean encodeValues = fieldMap.encodeValues();
                for (Map.Entry entry : ((Map)value).entrySet()) {
                    Object entryKey = entry.getKey();
                    if (entryKey == null) {
                        throw new IllegalArgumentException("Parameter #" + (i + 1) + " field map contained null key.");
                    }
                    Object entryValue = entry.getValue();
                    if (entryValue == null) continue;
                    this.formBody.addField(entryKey.toString(), encodeNames, entryValue.toString(), encodeValues);
                }
                continue;
            }
            if (annotationType == Part.class) {
                if (value == null) continue;
                name = ((Part)annotation).value();
                String transferEncoding = ((Part)annotation).encoding();
                if (value instanceof TypedOutput) {
                    this.multipartBody.addPart(name, transferEncoding, (TypedOutput)value);
                    continue;
                }
                if (value instanceof String) {
                    this.multipartBody.addPart(name, transferEncoding, new TypedString((String)value));
                    continue;
                }
                this.multipartBody.addPart(name, transferEncoding, this.converter.toBody(value));
                continue;
            }
            if (annotationType == PartMap.class) {
                if (value == null) continue;
                String transferEncoding = ((PartMap)annotation).encoding();
                for (Map.Entry entry : ((Map)value).entrySet()) {
                    Object entryKey = entry.getKey();
                    if (entryKey == null) {
                        throw new IllegalArgumentException("Parameter #" + (i + 1) + " part map contained null key.");
                    }
                    String entryName = entryKey.toString();
                    Object entryValue = entry.getValue();
                    if (entryValue == null) continue;
                    if (entryValue instanceof TypedOutput) {
                        this.multipartBody.addPart(entryName, transferEncoding, (TypedOutput)entryValue);
                        continue;
                    }
                    if (entryValue instanceof String) {
                        this.multipartBody.addPart(entryName, transferEncoding, new TypedString((String)entryValue));
                        continue;
                    }
                    this.multipartBody.addPart(entryName, transferEncoding, this.converter.toBody(entryValue));
                }
                continue;
            }
            if (annotationType == Body.class) {
                if (value == null) {
                    throw new IllegalArgumentException("Body parameter value must not be null.");
                }
                if (value instanceof TypedOutput) {
                    this.body = (TypedOutput)value;
                    continue;
                }
                this.body = this.converter.toBody(value);
                continue;
            }
            throw new IllegalArgumentException("Unknown annotation: " + annotationType.getCanonicalName());
        }
    }

    Request build() throws UnsupportedEncodingException {
        if (this.multipartBody != null && this.multipartBody.getPartCount() == 0) {
            throw new IllegalStateException("Multipart requests must contain at least one part.");
        }
        String apiUrl = this.apiUrl;
        StringBuilder url = new StringBuilder(apiUrl);
        if (apiUrl.endsWith("/")) {
            url.deleteCharAt(url.length() - 1);
        }
        url.append(this.relativeUrl);
        StringBuilder queryParams = this.queryParams;
        if (queryParams != null) {
            url.append((CharSequence)queryParams);
        }
        TypedOutput body = this.body;
        List<Header> headers = this.headers;
        if (this.contentTypeHeader != null) {
            if (body != null) {
                body = new MimeOverridingTypedOutput(body, this.contentTypeHeader);
            } else {
                Header header = new Header("Content-Type", this.contentTypeHeader);
                if (headers == null) {
                    headers = Collections.singletonList(header);
                } else {
                    headers.add(header);
                }
            }
        }
        return new Request(this.requestMethod, url.toString(), headers, body);
    }

    private static class MimeOverridingTypedOutput
    implements TypedOutput {
        private final TypedOutput delegate;
        private final String mimeType;

        MimeOverridingTypedOutput(TypedOutput delegate, String mimeType) {
            this.delegate = delegate;
            this.mimeType = mimeType;
        }

        @Override
        public String fileName() {
            return this.delegate.fileName();
        }

        @Override
        public String mimeType() {
            return this.mimeType;
        }

        @Override
        public long length() {
            return this.delegate.length();
        }

        @Override
        public void writeTo(OutputStream out) throws IOException {
            this.delegate.writeTo(out);
        }
    }
}

