/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.flume.influxdb.reporter.shade.org.influxdb.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import net.thisptr.flume.influxdb.reporter.shade.com.google.common.base.Joiner;
import net.thisptr.flume.influxdb.reporter.shade.com.google.common.base.Preconditions;
import net.thisptr.flume.influxdb.reporter.shade.com.google.common.base.Stopwatch;
import net.thisptr.flume.influxdb.reporter.shade.com.google.common.collect.Lists;
import net.thisptr.flume.influxdb.reporter.shade.org.influxdb.InfluxDB;
import net.thisptr.flume.influxdb.reporter.shade.org.influxdb.dto.BatchPoints;
import net.thisptr.flume.influxdb.reporter.shade.org.influxdb.dto.Point;
import net.thisptr.flume.influxdb.reporter.shade.org.influxdb.dto.Pong;
import net.thisptr.flume.influxdb.reporter.shade.org.influxdb.dto.Query;
import net.thisptr.flume.influxdb.reporter.shade.org.influxdb.dto.QueryResult;
import net.thisptr.flume.influxdb.reporter.shade.org.influxdb.impl.BatchProcessor;
import net.thisptr.flume.influxdb.reporter.shade.org.influxdb.impl.InfluxDBErrorHandler;
import net.thisptr.flume.influxdb.reporter.shade.org.influxdb.impl.InfluxDBService;
import net.thisptr.flume.influxdb.reporter.shade.org.influxdb.impl.TimeUtil;
import net.thisptr.flume.influxdb.reporter.shade.retrofit.RestAdapter;
import net.thisptr.flume.influxdb.reporter.shade.retrofit.client.Client;
import net.thisptr.flume.influxdb.reporter.shade.retrofit.client.Header;
import net.thisptr.flume.influxdb.reporter.shade.retrofit.client.Response;
import net.thisptr.flume.influxdb.reporter.shade.retrofit.mime.TypedString;

public class InfluxDBImpl
implements InfluxDB {
    private final String username;
    private final String password;
    private final RestAdapter restAdapter;
    private final InfluxDBService influxDBService;
    private BatchProcessor batchProcessor;
    private final AtomicBoolean batchEnabled = new AtomicBoolean(false);
    private final AtomicLong writeCount = new AtomicLong();
    private final AtomicLong unBatchedCount = new AtomicLong();
    private final AtomicLong batchedCount = new AtomicLong();
    private InfluxDB.LogLevel logLevel = InfluxDB.LogLevel.NONE;

    public InfluxDBImpl(String url, String username, String password, Client client) {
        this.username = username;
        this.password = password;
        this.restAdapter = new RestAdapter.Builder().setEndpoint(url).setErrorHandler(new InfluxDBErrorHandler()).setClient(client).build();
        this.influxDBService = this.restAdapter.create(InfluxDBService.class);
    }

    @Override
    public InfluxDB setLogLevel(InfluxDB.LogLevel logLevel) {
        switch (logLevel) {
            case NONE: {
                this.restAdapter.setLogLevel(RestAdapter.LogLevel.NONE);
                break;
            }
            case BASIC: {
                this.restAdapter.setLogLevel(RestAdapter.LogLevel.BASIC);
                break;
            }
            case HEADERS: {
                this.restAdapter.setLogLevel(RestAdapter.LogLevel.HEADERS);
                break;
            }
            case FULL: {
                this.restAdapter.setLogLevel(RestAdapter.LogLevel.FULL);
                break;
            }
        }
        this.logLevel = logLevel;
        return this;
    }

    @Override
    public InfluxDB enableBatch(int actions, int flushDuration, TimeUnit flushDurationTimeUnit) {
        if (this.batchEnabled.get()) {
            throw new IllegalArgumentException("BatchProcessing is already enabled.");
        }
        this.batchProcessor = BatchProcessor.builder(this).actions(actions).interval(flushDuration, flushDurationTimeUnit).build();
        this.batchEnabled.set(true);
        return this;
    }

    @Override
    public void disableBatch() {
        this.batchEnabled.set(false);
        this.batchProcessor.flush();
        if (this.logLevel != InfluxDB.LogLevel.NONE) {
            System.out.println("total writes:" + this.writeCount.get() + " unbatched:" + this.unBatchedCount.get() + "batchPoints:" + this.batchedCount);
        }
    }

    @Override
    public boolean isBatchEnabled() {
        return this.batchEnabled.get();
    }

    @Override
    public Pong ping() {
        Stopwatch watch = Stopwatch.createStarted();
        Response response = this.influxDBService.ping();
        List<Header> headers = response.getHeaders();
        String version = "unknown";
        for (Header header : headers) {
            if (null == header.getName() || !header.getName().equalsIgnoreCase("X-Influxdb-Version")) continue;
            version = header.getValue();
        }
        Pong pong = new Pong();
        pong.setVersion(version);
        pong.setResponseTime(watch.elapsed(TimeUnit.MILLISECONDS));
        return pong;
    }

    @Override
    public String version() {
        return this.ping().getVersion();
    }

    @Override
    public void write(String database, String retentionPolicy, Point point) {
        if (this.batchEnabled.get()) {
            BatchProcessor.BatchEntry batchEntry = new BatchProcessor.BatchEntry(point, database, retentionPolicy);
            this.batchProcessor.put(batchEntry);
        } else {
            BatchPoints batchPoints = BatchPoints.database(database).retentionPolicy(retentionPolicy).build();
            batchPoints.point(point);
            this.write(batchPoints);
            this.unBatchedCount.incrementAndGet();
        }
        this.writeCount.incrementAndGet();
    }

    @Override
    public void write(BatchPoints batchPoints) {
        this.batchedCount.addAndGet(batchPoints.getPoints().size());
        TypedString lineProtocol = new TypedString(batchPoints.lineProtocol());
        this.influxDBService.writePoints(this.username, this.password, batchPoints.getDatabase(), batchPoints.getRetentionPolicy(), TimeUtil.toTimePrecision(TimeUnit.NANOSECONDS), batchPoints.getConsistency().value(), lineProtocol);
    }

    @Override
    public void write(String database, String retentionPolicy, InfluxDB.ConsistencyLevel consistency, String records) {
        this.influxDBService.writePoints(this.username, this.password, database, retentionPolicy, TimeUtil.toTimePrecision(TimeUnit.NANOSECONDS), consistency.value(), new TypedString(records));
    }

    @Override
    public void write(String database, String retentionPolicy, InfluxDB.ConsistencyLevel consistency, List<String> records) {
        String joinedRecords = Joiner.on("\n").join(records);
        this.write(database, retentionPolicy, consistency, joinedRecords);
    }

    @Override
    public QueryResult query(Query query) {
        QueryResult response = this.influxDBService.query(this.username, this.password, query.getDatabase(), query.getCommand());
        return response;
    }

    @Override
    public QueryResult query(Query query, TimeUnit timeUnit) {
        QueryResult response = this.influxDBService.query(this.username, this.password, query.getDatabase(), TimeUtil.toTimePrecision(timeUnit), query.getCommand());
        return response;
    }

    @Override
    public void createDatabase(String name) {
        Preconditions.checkArgument(!name.contains("-"), "Databasename cant contain -");
        this.influxDBService.query(this.username, this.password, "CREATE DATABASE IF NOT EXISTS \"" + name + "\"");
    }

    @Override
    public void deleteDatabase(String name) {
        this.influxDBService.query(this.username, this.password, "DROP DATABASE \"" + name + "\"");
    }

    @Override
    public List<String> describeDatabases() {
        QueryResult result = this.influxDBService.query(this.username, this.password, "SHOW DATABASES");
        List<List<Object>> databaseNames = result.getResults().get(0).getSeries().get(0).getValues();
        ArrayList<String> databases = Lists.newArrayList();
        if (databaseNames != null) {
            for (List<Object> database : databaseNames) {
                databases.add(database.get(0).toString());
            }
        }
        return databases;
    }
}

