/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.flume.influxdb.reporter.shade.org.influxdb.impl;

import java.io.IOException;
import java.io.InputStreamReader;
import net.thisptr.flume.influxdb.reporter.shade.com.google.common.base.Charsets;
import net.thisptr.flume.influxdb.reporter.shade.com.google.common.io.CharStreams;
import net.thisptr.flume.influxdb.reporter.shade.retrofit.ErrorHandler;
import net.thisptr.flume.influxdb.reporter.shade.retrofit.RetrofitError;
import net.thisptr.flume.influxdb.reporter.shade.retrofit.client.Response;

class InfluxDBErrorHandler
implements ErrorHandler {
    InfluxDBErrorHandler() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Throwable handleError(RetrofitError cause) {
        Response r = cause.getResponse();
        if (r == null) return cause;
        if (r.getStatus() < 400) return cause;
        try (InputStreamReader reader = new InputStreamReader(r.getBody().in(), Charsets.UTF_8);){
            RuntimeException runtimeException = new RuntimeException(CharStreams.toString(reader));
            return runtimeException;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return cause;
    }
}

