/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.java.influxdb.metrics.agent;

import java.util.ArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import net.thisptr.flume.influxdb.reporter.shade.com.google.common.net.HostAndPort;
import net.thisptr.flume.influxdb.reporter.shade.com.google.common.util.concurrent.ThreadFactoryBuilder;
import net.thisptr.flume.influxdb.reporter.shade.org.influxdb.InfluxDB;
import net.thisptr.flume.influxdb.reporter.shade.org.influxdb.InfluxDBFactory;
import net.thisptr.java.influxdb.metrics.agent.JvmAgent;
import net.thisptr.java.influxdb.metrics.agent.JvmAgentCommand;
import net.thisptr.java.influxdb.metrics.agent.JvmAgentConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JvmAgentService {
    private static final Logger LOG = LoggerFactory.getLogger(JvmAgent.class);
    private final JvmAgentConfig config;
    private volatile ScheduledExecutorService executor;
    private final AtomicReference<State> state = new AtomicReference<State>(State.STOPPED);

    public JvmAgentService(JvmAgentConfig config) {
        this.config = config;
    }

    public void start() {
        if (!this.state.compareAndSet(State.STOPPED, State.STARTING)) {
            throw new IllegalStateException("InfluxDB Metrics Agent is expected to be in STOPPED state.");
        }
        LOG.info("Starting InfluxDB Metrics Agent...");
        try {
            ArrayList<InfluxDB> conns = new ArrayList<InfluxDB>(this.config.servers.size());
            for (HostAndPort server : this.config.servers) {
                try {
                    InfluxDB conn = InfluxDBFactory.connect("http://" + server, this.config.user, this.config.password);
                    conns.add(conn);
                }
                catch (Exception e) {
                    LOG.warn("Failed to connect to InfluxDB server {}.", (Object)server, (Object)e);
                }
            }
            this.executor = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("InfluxDB Metrics Agent %d").setDaemon(true).build());
            this.executor.scheduleWithFixedDelay(new JvmAgentCommand(conns, this.config), 0L, this.config.interval, TimeUnit.SECONDS);
            this.state.set(State.RUNNING);
        }
        catch (Throwable th) {
            LOG.error("Failed to start InfluxDB Metrics Agent.", th);
            this.state.set(State.STOPPED);
            throw th;
        }
    }

    public void stop() {
        if (!this.state.compareAndSet(State.RUNNING, State.STOPPING)) {
            throw new IllegalStateException("InfluxDB Metrics Agent is expected to be in RUNNING state.");
        }
        LOG.info("Stopping InfluxDB Metrics Agent...");
        try {
            this.executor.shutdown();
            while (!this.executor.isTerminated()) {
                try {
                    LOG.info("Waiting for InfluxDB Metrics Agent to stop...");
                    this.executor.awaitTermination(1L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    LOG.warn("Interrupted while waiting for InfluxDB Metrics Agent to shutdown.", (Throwable)e);
                    this.executor.shutdownNow();
                }
            }
        }
        finally {
            this.state.set(State.STOPPED);
        }
    }

    private static enum State {
        STARTING,
        RUNNING,
        STOPPING,
        STOPPED;

    }
}

