/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.flume.influxdb.reporter.shade.retrofit.mime;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import net.thisptr.flume.influxdb.reporter.shade.retrofit.mime.TypedOutput;

public final class FormUrlEncodedTypedOutput
implements TypedOutput {
    final ByteArrayOutputStream content = new ByteArrayOutputStream();

    public void addField(String name, String value) {
        this.addField(name, true, value, true);
    }

    public void addField(String name, boolean encodeName, String value, boolean encodeValue) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        if (this.content.size() > 0) {
            this.content.write(38);
        }
        try {
            if (encodeName) {
                name = URLEncoder.encode(name, "UTF-8");
            }
            if (encodeValue) {
                value = URLEncoder.encode(value, "UTF-8");
            }
            this.content.write(name.getBytes("UTF-8"));
            this.content.write(61);
            this.content.write(value.getBytes("UTF-8"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String fileName() {
        return null;
    }

    @Override
    public String mimeType() {
        return "application/x-www-form-urlencoded; charset=UTF-8";
    }

    @Override
    public long length() {
        return this.content.size();
    }

    @Override
    public void writeTo(OutputStream out) throws IOException {
        out.write(this.content.toByteArray());
    }
}

