/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.flume.influxdb.reporter.shade.com.squareup.okhttp.internal.http;

import java.io.EOFException;
import java.io.IOException;
import java.net.ProtocolException;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.concurrent.TimeUnit;
import net.thisptr.flume.influxdb.reporter.shade.com.squareup.okhttp.Connection;
import net.thisptr.flume.influxdb.reporter.shade.com.squareup.okhttp.ConnectionPool;
import net.thisptr.flume.influxdb.reporter.shade.com.squareup.okhttp.Headers;
import net.thisptr.flume.influxdb.reporter.shade.com.squareup.okhttp.Response;
import net.thisptr.flume.influxdb.reporter.shade.com.squareup.okhttp.internal.Internal;
import net.thisptr.flume.influxdb.reporter.shade.com.squareup.okhttp.internal.Util;
import net.thisptr.flume.influxdb.reporter.shade.com.squareup.okhttp.internal.http.HttpEngine;
import net.thisptr.flume.influxdb.reporter.shade.com.squareup.okhttp.internal.http.OkHeaders;
import net.thisptr.flume.influxdb.reporter.shade.com.squareup.okhttp.internal.http.RetryableSink;
import net.thisptr.flume.influxdb.reporter.shade.com.squareup.okhttp.internal.http.StatusLine;
import net.thisptr.flume.influxdb.reporter.shade.okio.Buffer;
import net.thisptr.flume.influxdb.reporter.shade.okio.BufferedSink;
import net.thisptr.flume.influxdb.reporter.shade.okio.BufferedSource;
import net.thisptr.flume.influxdb.reporter.shade.okio.ForwardingTimeout;
import net.thisptr.flume.influxdb.reporter.shade.okio.Okio;
import net.thisptr.flume.influxdb.reporter.shade.okio.Sink;
import net.thisptr.flume.influxdb.reporter.shade.okio.Source;
import net.thisptr.flume.influxdb.reporter.shade.okio.Timeout;

public final class HttpConnection {
    private static final int STATE_IDLE = 0;
    private static final int STATE_OPEN_REQUEST_BODY = 1;
    private static final int STATE_WRITING_REQUEST_BODY = 2;
    private static final int STATE_READ_RESPONSE_HEADERS = 3;
    private static final int STATE_OPEN_RESPONSE_BODY = 4;
    private static final int STATE_READING_RESPONSE_BODY = 5;
    private static final int STATE_CLOSED = 6;
    private static final int ON_IDLE_HOLD = 0;
    private static final int ON_IDLE_POOL = 1;
    private static final int ON_IDLE_CLOSE = 2;
    private final ConnectionPool pool;
    private final Connection connection;
    private final Socket socket;
    private final BufferedSource source;
    private final BufferedSink sink;
    private int state = 0;
    private int onIdle = 0;

    public HttpConnection(ConnectionPool pool, Connection connection, Socket socket) throws IOException {
        this.pool = pool;
        this.connection = connection;
        this.socket = socket;
        this.source = Okio.buffer(Okio.source(socket));
        this.sink = Okio.buffer(Okio.sink(socket));
    }

    public void setTimeouts(int readTimeoutMillis, int writeTimeoutMillis) {
        if (readTimeoutMillis != 0) {
            this.source.timeout().timeout(readTimeoutMillis, TimeUnit.MILLISECONDS);
        }
        if (writeTimeoutMillis != 0) {
            this.sink.timeout().timeout(writeTimeoutMillis, TimeUnit.MILLISECONDS);
        }
    }

    public void poolOnIdle() {
        this.onIdle = 1;
        if (this.state == 0) {
            this.onIdle = 0;
            Internal.instance.recycle(this.pool, this.connection);
        }
    }

    public void closeOnIdle() throws IOException {
        this.onIdle = 2;
        if (this.state == 0) {
            this.state = 6;
            this.connection.getSocket().close();
        }
    }

    public boolean isClosed() {
        return this.state == 6;
    }

    public void closeIfOwnedBy(Object owner) throws IOException {
        Internal.instance.closeIfOwnedBy(this.connection, owner);
    }

    public void flush() throws IOException {
        this.sink.flush();
    }

    public long bufferSize() {
        return this.source.buffer().size();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isReadable() {
        try {
            int readTimeout = this.socket.getSoTimeout();
            try {
                this.socket.setSoTimeout(1);
                if (this.source.exhausted()) {
                    boolean bl = false;
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
            finally {
                this.socket.setSoTimeout(readTimeout);
            }
        }
        catch (SocketTimeoutException ignored) {
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public void writeRequest(Headers headers, String requestLine) throws IOException {
        if (this.state != 0) {
            throw new IllegalStateException("state: " + this.state);
        }
        this.sink.writeUtf8(requestLine).writeUtf8("\r\n");
        int size = headers.size();
        for (int i = 0; i < size; ++i) {
            this.sink.writeUtf8(headers.name(i)).writeUtf8(": ").writeUtf8(headers.value(i)).writeUtf8("\r\n");
        }
        this.sink.writeUtf8("\r\n");
        this.state = 1;
    }

    public Response.Builder readResponse() throws IOException {
        if (this.state != 1 && this.state != 3) {
            throw new IllegalStateException("state: " + this.state);
        }
        try {
            Response.Builder responseBuilder;
            StatusLine statusLine;
            do {
                statusLine = StatusLine.parse(this.source.readUtf8LineStrict());
                responseBuilder = new Response.Builder().protocol(statusLine.protocol).code(statusLine.code).message(statusLine.message);
                Headers.Builder headersBuilder = new Headers.Builder();
                this.readHeaders(headersBuilder);
                headersBuilder.add(OkHeaders.SELECTED_PROTOCOL, statusLine.protocol.toString());
                responseBuilder.headers(headersBuilder.build());
            } while (statusLine.code == 100);
            this.state = 4;
            return responseBuilder;
        }
        catch (EOFException e) {
            IOException exception = new IOException("unexpected end of stream on " + this.connection + " (recycle count=" + Internal.instance.recycleCount(this.connection) + ")");
            exception.initCause(e);
            throw exception;
        }
    }

    public void readHeaders(Headers.Builder builder) throws IOException {
        String line;
        while ((line = this.source.readUtf8LineStrict()).length() != 0) {
            Internal.instance.addLenient(builder, line);
        }
    }

    public Sink newChunkedSink() {
        if (this.state != 1) {
            throw new IllegalStateException("state: " + this.state);
        }
        this.state = 2;
        return new ChunkedSink();
    }

    public Sink newFixedLengthSink(long contentLength) {
        if (this.state != 1) {
            throw new IllegalStateException("state: " + this.state);
        }
        this.state = 2;
        return new FixedLengthSink(contentLength);
    }

    public void writeRequestBody(RetryableSink requestBody) throws IOException {
        if (this.state != 1) {
            throw new IllegalStateException("state: " + this.state);
        }
        this.state = 3;
        requestBody.writeToSocket(this.sink);
    }

    public Source newFixedLengthSource(long length) throws IOException {
        if (this.state != 4) {
            throw new IllegalStateException("state: " + this.state);
        }
        this.state = 5;
        return new FixedLengthSource(length);
    }

    public Source newChunkedSource(HttpEngine httpEngine) throws IOException {
        if (this.state != 4) {
            throw new IllegalStateException("state: " + this.state);
        }
        this.state = 5;
        return new ChunkedSource(httpEngine);
    }

    public Source newUnknownLengthSource() throws IOException {
        if (this.state != 4) {
            throw new IllegalStateException("state: " + this.state);
        }
        this.state = 5;
        return new UnknownLengthSource();
    }

    public BufferedSink rawSink() {
        return this.sink;
    }

    public BufferedSource rawSource() {
        return this.source;
    }

    private void detachTimeout(ForwardingTimeout timeout) {
        Timeout oldDelegate = timeout.delegate();
        timeout.setDelegate(Timeout.NONE);
        oldDelegate.clearDeadline();
        oldDelegate.clearTimeout();
    }

    private class UnknownLengthSource
    extends AbstractSource {
        private boolean inputExhausted;

        private UnknownLengthSource() {
        }

        @Override
        public long read(Buffer sink, long byteCount) throws IOException {
            if (byteCount < 0L) {
                throw new IllegalArgumentException("byteCount < 0: " + byteCount);
            }
            if (this.closed) {
                throw new IllegalStateException("closed");
            }
            if (this.inputExhausted) {
                return -1L;
            }
            long read = HttpConnection.this.source.read(sink, byteCount);
            if (read == -1L) {
                this.inputExhausted = true;
                this.endOfInput(false);
                return -1L;
            }
            return read;
        }

        @Override
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            if (!this.inputExhausted) {
                this.unexpectedEndOfInput();
            }
            this.closed = true;
        }
    }

    private class ChunkedSource
    extends AbstractSource {
        private static final long NO_CHUNK_YET = -1L;
        private long bytesRemainingInChunk;
        private boolean hasMoreChunks;
        private final HttpEngine httpEngine;

        ChunkedSource(HttpEngine httpEngine) throws IOException {
            this.bytesRemainingInChunk = -1L;
            this.hasMoreChunks = true;
            this.httpEngine = httpEngine;
        }

        @Override
        public long read(Buffer sink, long byteCount) throws IOException {
            long read;
            if (byteCount < 0L) {
                throw new IllegalArgumentException("byteCount < 0: " + byteCount);
            }
            if (this.closed) {
                throw new IllegalStateException("closed");
            }
            if (!this.hasMoreChunks) {
                return -1L;
            }
            if (this.bytesRemainingInChunk == 0L || this.bytesRemainingInChunk == -1L) {
                this.readChunkSize();
                if (!this.hasMoreChunks) {
                    return -1L;
                }
            }
            if ((read = HttpConnection.this.source.read(sink, Math.min(byteCount, this.bytesRemainingInChunk))) == -1L) {
                this.unexpectedEndOfInput();
                throw new IOException("unexpected end of stream");
            }
            this.bytesRemainingInChunk -= read;
            return read;
        }

        private void readChunkSize() throws IOException {
            if (this.bytesRemainingInChunk != -1L) {
                HttpConnection.this.source.readUtf8LineStrict();
            }
            try {
                this.bytesRemainingInChunk = HttpConnection.this.source.readHexadecimalUnsignedLong();
                String extensions = HttpConnection.this.source.readUtf8LineStrict().trim();
                if (this.bytesRemainingInChunk < 0L || !extensions.isEmpty() && !extensions.startsWith(";")) {
                    throw new ProtocolException("expected chunk size and optional extensions but was \"" + this.bytesRemainingInChunk + extensions + "\"");
                }
            }
            catch (NumberFormatException e) {
                throw new ProtocolException(e.getMessage());
            }
            if (this.bytesRemainingInChunk == 0L) {
                this.hasMoreChunks = false;
                Headers.Builder trailersBuilder = new Headers.Builder();
                HttpConnection.this.readHeaders(trailersBuilder);
                this.httpEngine.receiveHeaders(trailersBuilder.build());
                this.endOfInput(true);
            }
        }

        @Override
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            if (this.hasMoreChunks && !Util.discard(this, 100, TimeUnit.MILLISECONDS)) {
                this.unexpectedEndOfInput();
            }
            this.closed = true;
        }
    }

    private class FixedLengthSource
    extends AbstractSource {
        private long bytesRemaining;

        public FixedLengthSource(long length) throws IOException {
            this.bytesRemaining = length;
            if (this.bytesRemaining == 0L) {
                this.endOfInput(true);
            }
        }

        @Override
        public long read(Buffer sink, long byteCount) throws IOException {
            if (byteCount < 0L) {
                throw new IllegalArgumentException("byteCount < 0: " + byteCount);
            }
            if (this.closed) {
                throw new IllegalStateException("closed");
            }
            if (this.bytesRemaining == 0L) {
                return -1L;
            }
            long read = HttpConnection.this.source.read(sink, Math.min(this.bytesRemaining, byteCount));
            if (read == -1L) {
                this.unexpectedEndOfInput();
                throw new ProtocolException("unexpected end of stream");
            }
            this.bytesRemaining -= read;
            if (this.bytesRemaining == 0L) {
                this.endOfInput(true);
            }
            return read;
        }

        @Override
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            if (this.bytesRemaining != 0L && !Util.discard(this, 100, TimeUnit.MILLISECONDS)) {
                this.unexpectedEndOfInput();
            }
            this.closed = true;
        }
    }

    private abstract class AbstractSource
    implements Source {
        protected final ForwardingTimeout timeout;
        protected boolean closed;

        private AbstractSource() {
            this.timeout = new ForwardingTimeout(HttpConnection.this.source.timeout());
        }

        @Override
        public Timeout timeout() {
            return this.timeout;
        }

        protected final void endOfInput(boolean recyclable) throws IOException {
            if (HttpConnection.this.state != 5) {
                throw new IllegalStateException("state: " + HttpConnection.this.state);
            }
            HttpConnection.this.detachTimeout(this.timeout);
            HttpConnection.this.state = 0;
            if (recyclable && HttpConnection.this.onIdle == 1) {
                HttpConnection.this.onIdle = 0;
                Internal.instance.recycle(HttpConnection.this.pool, HttpConnection.this.connection);
            } else if (HttpConnection.this.onIdle == 2) {
                HttpConnection.this.state = 6;
                HttpConnection.this.connection.getSocket().close();
            }
        }

        protected final void unexpectedEndOfInput() {
            Util.closeQuietly(HttpConnection.this.connection.getSocket());
            HttpConnection.this.state = 6;
        }
    }

    private final class ChunkedSink
    implements Sink {
        private final ForwardingTimeout timeout;
        private boolean closed;

        private ChunkedSink() {
            this.timeout = new ForwardingTimeout(HttpConnection.this.sink.timeout());
        }

        @Override
        public Timeout timeout() {
            return this.timeout;
        }

        @Override
        public void write(Buffer source, long byteCount) throws IOException {
            if (this.closed) {
                throw new IllegalStateException("closed");
            }
            if (byteCount == 0L) {
                return;
            }
            HttpConnection.this.sink.writeHexadecimalUnsignedLong(byteCount);
            HttpConnection.this.sink.writeUtf8("\r\n");
            HttpConnection.this.sink.write(source, byteCount);
            HttpConnection.this.sink.writeUtf8("\r\n");
        }

        @Override
        public synchronized void flush() throws IOException {
            if (this.closed) {
                return;
            }
            HttpConnection.this.sink.flush();
        }

        @Override
        public synchronized void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.closed = true;
            HttpConnection.this.sink.writeUtf8("0\r\n\r\n");
            HttpConnection.this.detachTimeout(this.timeout);
            HttpConnection.this.state = 3;
        }
    }

    private final class FixedLengthSink
    implements Sink {
        private final ForwardingTimeout timeout;
        private boolean closed;
        private long bytesRemaining;

        private FixedLengthSink(long bytesRemaining) {
            this.timeout = new ForwardingTimeout(HttpConnection.this.sink.timeout());
            this.bytesRemaining = bytesRemaining;
        }

        @Override
        public Timeout timeout() {
            return this.timeout;
        }

        @Override
        public void write(Buffer source, long byteCount) throws IOException {
            if (this.closed) {
                throw new IllegalStateException("closed");
            }
            Util.checkOffsetAndCount(source.size(), 0L, byteCount);
            if (byteCount > this.bytesRemaining) {
                throw new ProtocolException("expected " + this.bytesRemaining + " bytes but received " + byteCount);
            }
            HttpConnection.this.sink.write(source, byteCount);
            this.bytesRemaining -= byteCount;
        }

        @Override
        public void flush() throws IOException {
            if (this.closed) {
                return;
            }
            HttpConnection.this.sink.flush();
        }

        @Override
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.closed = true;
            if (this.bytesRemaining > 0L) {
                throw new ProtocolException("unexpected end of stream");
            }
            HttpConnection.this.detachTimeout(this.timeout);
            HttpConnection.this.state = 3;
        }
    }
}

