/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jackson.jq.internal.operators;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.TextNode;
import net.thisptr.jackson.jq.exception.JsonQueryException;
import net.thisptr.jackson.jq.exception.JsonQueryTypeException;
import net.thisptr.jackson.jq.internal.misc.JsonNodeUtils;
import net.thisptr.jackson.jq.internal.misc.Strings;
import net.thisptr.jackson.jq.internal.operators.BinaryOperator;

public class DivideOperator
implements BinaryOperator {
    @Override
    public JsonNode apply(ObjectMapper mapper, JsonNode lhs, JsonNode rhs) throws JsonQueryException {
        if (lhs.isNumber() && rhs.isNumber()) {
            double divisor = rhs.asDouble();
            double dividend = lhs.asDouble();
            if (divisor == 0.0) {
                throw new JsonQueryException("%s and %s cannot be divided because the divisor is zero", lhs, rhs);
            }
            return JsonNodeUtils.asNumericNode(dividend / divisor);
        }
        if (lhs.isTextual() && rhs.isTextual()) {
            ArrayNode result = mapper.createArrayNode();
            for (String token : Strings.split(lhs.asText(), rhs.asText())) {
                result.add((JsonNode)new TextNode(token));
            }
            return result;
        }
        throw new JsonQueryTypeException("%s and %s cannot be divided", lhs, rhs);
    }

    @Override
    public String image() {
        return "/";
    }
}

