/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jackson.jq.internal.functions;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.auto.service.AutoService;
import java.util.List;
import net.thisptr.jackson.jq.BuiltinFunction;
import net.thisptr.jackson.jq.Expression;
import net.thisptr.jackson.jq.Function;
import net.thisptr.jackson.jq.PathOutput;
import net.thisptr.jackson.jq.Scope;
import net.thisptr.jackson.jq.Version;
import net.thisptr.jackson.jq.Versions;
import net.thisptr.jackson.jq.exception.JsonQueryException;
import net.thisptr.jackson.jq.exception.JsonQueryTypeException;
import net.thisptr.jackson.jq.path.Path;

@BuiltinFunction(value={"join/1"})
@AutoService(value={Function.class})
public class JoinFunction
implements Function {
    @Override
    public void apply(Scope scope, List<Expression> args, JsonNode in, Path ipath, PathOutput output, Version version) throws JsonQueryException {
        args.get(0).apply(scope, in, sep -> {
            if (!in.isArray() && !in.isObject()) {
                throw new JsonQueryTypeException("Cannot iterate over %s", in);
            }
            JsonNode isep = null;
            StringBuilder builder = new StringBuilder();
            for (JsonNode item : in) {
                if (isep != null) {
                    if (isep.isTextual()) {
                        builder.append(isep.asText());
                    } else if (!isep.isNull()) {
                        throw new JsonQueryTypeException("%s and %s cannot be added", new TextNode(builder.toString()), isep);
                    }
                }
                if (item.isTextual()) {
                    builder.append(item.asText());
                } else if (!item.isNull()) {
                    if (version.compareTo(Versions.JQ_1_6) >= 0 && (item.isNumber() || item.isBoolean())) {
                        builder.append(item.toString());
                    } else {
                        if (version.compareTo(Versions.JQ_1_6) >= 0) {
                            throw new JsonQueryTypeException("%s and %s cannot be added", new TextNode(builder.toString()), item);
                        }
                        throw new JsonQueryTypeException("%s and %s cannot be added", sep, item);
                    }
                }
                isep = sep;
            }
            output.emit((JsonNode)new TextNode(builder.toString()), null);
        });
    }
}

