/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jackson.jq.internal.tree;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.List;
import net.thisptr.jackson.jq.Expression;
import net.thisptr.jackson.jq.PathOutput;
import net.thisptr.jackson.jq.Scope;
import net.thisptr.jackson.jq.exception.JsonQueryException;
import net.thisptr.jackson.jq.internal.tree.ImportStatement;
import net.thisptr.jackson.jq.internal.tree.ModuleDirective;
import net.thisptr.jackson.jq.module.Module;
import net.thisptr.jackson.jq.module.ModuleLoader;
import net.thisptr.jackson.jq.path.Path;

public class TopLevelExpression
implements Expression {
    private final List<ImportStatement> imports;
    private final Expression expr;
    private final ModuleDirective moduleDirective;

    public TopLevelExpression(ModuleDirective moduleDirective, List<ImportStatement> imports, Expression expr) {
        this.moduleDirective = moduleDirective;
        this.imports = imports;
        this.expr = expr;
    }

    @Override
    public void apply(Scope scope, JsonNode in, Path ipath, PathOutput output, boolean requirePath) throws JsonQueryException {
        ModuleLoader moduleLoader = scope.getModuleLoader();
        for (ImportStatement imp : this.imports) {
            if (!imp.dollarImport) {
                Module module = moduleLoader.loadModule(scope.getCurrentModule(), imp.path, imp.metadata);
                if (module == null) {
                    throw new JsonQueryException("module not found: " + imp.path);
                }
                scope.addImportedModule(imp.name, module);
                continue;
            }
            JsonNode data = moduleLoader.loadData(scope.getCurrentModule(), imp.path, imp.metadata);
            if (data == null) {
                throw new JsonQueryException("module not found: " + imp.path);
            }
            scope.setImportedData(imp.name, data);
        }
        this.expr.apply(scope, in, ipath, output, requirePath);
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        if (this.moduleDirective != null) {
            s.append(this.moduleDirective);
            s.append("; ");
        }
        for (ImportStatement imp : this.imports) {
            s.append(imp);
            s.append("; ");
        }
        s.append(this.expr);
        return s.toString();
    }
}

