/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jackson.jq.internal.functions;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.IntNode;
import com.google.auto.service.AutoService;
import java.util.List;
import net.thisptr.jackson.jq.BuiltinFunction;
import net.thisptr.jackson.jq.Expression;
import net.thisptr.jackson.jq.Function;
import net.thisptr.jackson.jq.PathOutput;
import net.thisptr.jackson.jq.Scope;
import net.thisptr.jackson.jq.Version;
import net.thisptr.jackson.jq.Versions;
import net.thisptr.jackson.jq.exception.JsonQueryException;
import net.thisptr.jackson.jq.exception.JsonQueryTypeException;
import net.thisptr.jackson.jq.internal.misc.JsonNodeComparator;
import net.thisptr.jackson.jq.internal.misc.JsonNodeUtils;
import net.thisptr.jackson.jq.internal.operators.PlusOperator;
import net.thisptr.jackson.jq.path.Path;

@BuiltinFunction(value={"range/1", "range/2", "range/3"})
@AutoService(value={Function.class})
public class RangeFunction
implements Function {
    private static final JsonNodeComparator COMPARATOR = JsonNodeComparator.getInstance();
    private static final PlusOperator OPERATOR = new PlusOperator();
    private static final ObjectMapper MAPPER = new ObjectMapper();

    @Override
    public void apply(Scope scope, List<Expression> args, JsonNode in, Path ipath, PathOutput output, Version version) throws JsonQueryException {
        if (args.size() == 1) {
            args.get(0).apply(scope, in, end -> RangeFunction.range1(output, end));
        } else if (args.size() == 2) {
            args.get(0).apply(scope, in, start -> {
                if (version.compareTo(Versions.JQ_1_5) <= 0) {
                    JsonNode[] cur = new JsonNode[]{start};
                    ((Expression)args.get(1)).apply(scope, in, end -> {
                        cur[0] = RangeFunction.range2(output, cur[0], end);
                    });
                } else {
                    ((Expression)args.get(1)).apply(scope, in, end -> RangeFunction.range2(output, start, end));
                }
            });
        } else {
            args.get(0).apply(scope, in, start -> ((Expression)args.get(1)).apply(scope, in, end -> ((Expression)args.get(2)).apply(scope, in, incr -> RangeFunction.range3(output, start, end, incr))));
        }
    }

    private static void range1(PathOutput output, JsonNode end) throws JsonQueryException {
        RangeFunction.range2(output, (JsonNode)IntNode.valueOf((int)0), end);
    }

    private static JsonNode range2(PathOutput output, JsonNode start, JsonNode end) throws JsonQueryException {
        double i;
        if (!start.isNumber() || !end.isNumber()) {
            throw new JsonQueryTypeException("Range bounds must be numeric");
        }
        double _start = start.asDouble();
        double _end = end.asDouble();
        for (i = _start; i < _end; i += 1.0) {
            output.emit(JsonNodeUtils.asNumericNode(i), null);
        }
        return JsonNodeUtils.asNumericNode(i);
    }

    private static void range3(PathOutput output, JsonNode start, JsonNode end, JsonNode incr) throws JsonQueryException {
        int dir = Integer.signum(COMPARATOR.compare((JsonNode)IntNode.valueOf((int)0), incr));
        if (dir == 0) {
            return;
        }
        JsonNode cur = start;
        while (Integer.signum(COMPARATOR.compare(cur, end)) == dir) {
            output.emit(cur, null);
            cur = OPERATOR.apply(MAPPER, cur, incr);
        }
    }
}

