/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jackson.jq.internal.functions;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.google.auto.service.AutoService;
import java.util.List;
import net.thisptr.jackson.jq.BuiltinFunction;
import net.thisptr.jackson.jq.Expression;
import net.thisptr.jackson.jq.Function;
import net.thisptr.jackson.jq.PathOutput;
import net.thisptr.jackson.jq.Scope;
import net.thisptr.jackson.jq.Version;
import net.thisptr.jackson.jq.exception.JsonQueryException;
import net.thisptr.jackson.jq.exception.JsonQueryTypeException;
import net.thisptr.jackson.jq.internal.misc.JsonNodeUtils;
import net.thisptr.jackson.jq.internal.misc.UnicodeUtils;
import net.thisptr.jackson.jq.path.Path;

@BuiltinFunction(value={"length/0"})
@AutoService(value={Function.class})
public class LengthFunction
implements Function {
    @Override
    public void apply(Scope scope, List<Expression> args, JsonNode in, Path ipath, PathOutput output, Version version) throws JsonQueryException {
        output.emit(this.length(in), null);
    }

    public JsonNode length(JsonNode in) throws JsonQueryException {
        if (in.isTextual()) {
            return IntNode.valueOf((int)UnicodeUtils.lengthUtf32(in.asText()));
        }
        if (in.isArray() || in.isObject()) {
            return new IntNode(in.size());
        }
        if (in.isNull()) {
            return new IntNode(0);
        }
        if (in.isNumber()) {
            return JsonNodeUtils.asNumericNode(Math.abs(in.asDouble()));
        }
        throw new JsonQueryTypeException("%s has no length", in);
    }
}

