/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jackson.jq.internal.functions;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.NullNode;
import com.google.auto.service.AutoService;
import java.util.ArrayList;
import java.util.List;
import net.thisptr.jackson.jq.BuiltinFunction;
import net.thisptr.jackson.jq.Expression;
import net.thisptr.jackson.jq.Function;
import net.thisptr.jackson.jq.PathOutput;
import net.thisptr.jackson.jq.Scope;
import net.thisptr.jackson.jq.Version;
import net.thisptr.jackson.jq.exception.JsonQueryException;
import net.thisptr.jackson.jq.internal.misc.JsonNodeComparator;
import net.thisptr.jackson.jq.internal.misc.Preconditions;
import net.thisptr.jackson.jq.path.Path;

@BuiltinFunction(value={"indices/1"})
@AutoService(value={Function.class})
public class IndicesFunction
implements Function {
    private static final JsonNodeComparator comparator = JsonNodeComparator.getInstance();

    @Override
    public void apply(Scope scope, List<Expression> args, JsonNode in, Path ipath, PathOutput output, Version version) throws JsonQueryException {
        Preconditions.checkInputType("indices", in, JsonNodeType.STRING, JsonNodeType.ARRAY, JsonNodeType.NULL);
        if (in.isNull()) {
            output.emit((JsonNode)NullNode.getInstance(), null);
            return;
        }
        args.get(0).apply(scope, in, needle -> {
            ArrayNode indices = scope.getObjectMapper().createArrayNode();
            for (int index : IndicesFunction.indices(needle, in)) {
                indices.add(index);
            }
            output.emit((JsonNode)indices, null);
        });
    }

    public static List<Integer> indices(JsonNode needle, JsonNode haystack) throws JsonQueryException {
        ArrayList<Integer> result = new ArrayList<Integer>();
        if (needle.isTextual() && haystack.isTextual()) {
            String haystackText = haystack.asText();
            String needleText = needle.asText();
            if (!needleText.isEmpty()) {
                int index = haystackText.indexOf(needleText);
                while (index >= 0) {
                    result.add(index);
                    index = haystackText.indexOf(needleText, index + 1);
                }
            }
        } else if (needle.isArray() && haystack.isArray()) {
            if (needle.size() != 0) {
                for (int i = 0; i < haystack.size(); ++i) {
                    boolean match = true;
                    for (int j = 0; j < needle.size(); ++j) {
                        if (i + j < haystack.size() && comparator.compare(haystack.get(i + j), needle.get(j)) == 0) continue;
                        match = false;
                        break;
                    }
                    if (!match) continue;
                    result.add(i);
                }
            }
        } else if (haystack.isArray()) {
            for (int i = 0; i < haystack.size(); ++i) {
                if (comparator.compare(haystack.get(i), needle) != 0) continue;
                result.add(i);
            }
        } else {
            throw new JsonQueryException("indices() is not applicable to " + haystack.getNodeType());
        }
        return result;
    }
}

