/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jackson.jq.internal.tree;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.NullNode;
import java.util.ArrayList;
import java.util.Stack;
import net.thisptr.jackson.jq.Expression;
import net.thisptr.jackson.jq.PathOutput;
import net.thisptr.jackson.jq.Scope;
import net.thisptr.jackson.jq.exception.JsonQueryException;
import net.thisptr.jackson.jq.internal.misc.Pair;
import net.thisptr.jackson.jq.internal.tree.matcher.PatternMatcher;
import net.thisptr.jackson.jq.path.Path;

public class ReduceExpression
implements Expression {
    private Expression iterExpr;
    private Expression reduceExpr;
    private Expression initExpr;
    private PatternMatcher matcher;

    public ReduceExpression(PatternMatcher matcher, Expression initExpr, Expression reduceExpr, Expression iterExpr) {
        this.matcher = matcher;
        this.initExpr = initExpr;
        this.reduceExpr = reduceExpr;
        this.iterExpr = iterExpr;
    }

    @Override
    public void apply(Scope scope, JsonNode in, Path ipath, PathOutput output, boolean requirePath) throws JsonQueryException {
        this.initExpr.apply(scope, in, accumulator -> {
            JsonNode[] accumulators = new JsonNode[]{accumulator};
            Scope childScope = Scope.newChildScope(scope);
            this.iterExpr.apply(scope, in, item -> {
                Stack<Pair<String, JsonNode>> stack = new Stack<Pair<String, JsonNode>>();
                this.matcher.match(scope, item, vars -> {
                    for (int i = vars.size() - 1; i >= 0; --i) {
                        Pair var = (Pair)vars.get(i);
                        childScope.setValue((String)var._1, (JsonNode)var._2);
                    }
                    ArrayList reduceResult = new ArrayList();
                    this.reduceExpr.apply(childScope, accumulators[0], reduceResult::add);
                    accumulators[0] = reduceResult.isEmpty() ? NullNode.getInstance() : (JsonNode)reduceResult.get(reduceResult.size() - 1);
                }, stack, true);
            });
            output.emit(accumulators[0], null);
        });
    }

    public String toString() {
        return String.format("(reduce %s as %s (%s; %s))", this.iterExpr, this.matcher, this.initExpr, this.reduceExpr);
    }
}

