/*
 * Decompiled with CFR 0.152.
 */
package org.bff.javampd.properties;

import com.google.inject.Singleton;
import org.bff.javampd.properties.MPDProperties;

@Singleton
public class ServerProperties
extends MPDProperties {
    public String getClearError() {
        return this.getResponseCommand(Command.CLEARERROR);
    }

    public String getKill() {
        return this.getResponseCommand(Command.KILL);
    }

    public String getStatus() {
        return this.getResponseCommand(Command.STATUS);
    }

    public String getStats() {
        return this.getResponseCommand(Command.STATS);
    }

    public String getPing() {
        return this.getResponseCommand(Command.PING);
    }

    public String getPassword() {
        return this.getResponseCommand(Command.PASSWORD);
    }

    public String getClose() {
        return this.getResponseCommand(Command.CLOSE);
    }

    public String getStartBulk() {
        return this.getResponseCommand(Command.STARTBULK);
    }

    public String getEndBulk() {
        return this.getResponseCommand(Command.ENDBULK);
    }

    private String getResponseCommand(Command command) {
        return this.getPropertyString(command.getKey());
    }

    public String getEncoding() {
        return this.getResponseCommand(Command.SERVERENCODING);
    }

    private static enum Command {
        SERVERENCODING("MPD_SERVER_ENCODING"),
        CLEARERROR("MPD_CMD_CLEAR_ERROR"),
        CLOSE("MPD_CMD_CLOSE"),
        KILL("MPD_CMD_KILL"),
        STATUS("MPD_CMD_STATUS"),
        STATS("MPD_CMD_STATISTICS"),
        STARTBULK("MPD_CMD_START_BULK"),
        ENDBULK("MPD_CMD_END_BULK"),
        PASSWORD("MPD_CMD_PASSWORD"),
        PING("MPD_CMD_PING");

        private final String key;

        private Command(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }
    }
}

