/*
 * Decompiled with CFR 0.152.
 */
package org.bff.javampd.properties;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.bff.javampd.properties.PropertyLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MPDProperties
implements PropertyLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(MPDProperties.class);
    private Properties prop;
    private static final String PROPFILE = "/mpd.properties";

    protected MPDProperties() {
        this.loadValues();
    }

    @Override
    public String getPropertyString(String property) {
        return this.prop.getProperty(property);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadValues() {
        this.prop = new Properties();
        InputStream is = MPDProperties.class.getResourceAsStream(PROPFILE);
        try {
            this.prop.load(is);
        }
        catch (Exception e) {
            LOGGER.error("Could not load properties values", (Throwable)e);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException ex) {
                LOGGER.error("Could not close properties file stream", (Throwable)ex);
            }
        }
    }
}

