/*
 * Decompiled with CFR 0.152.
 */
package org.bff.javampd.processor;

import org.bff.javampd.objects.MPDSong;
import org.bff.javampd.processor.SongResponseProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrackProcessor
extends SongResponseProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(TrackProcessor.class);

    public TrackProcessor() {
        super("Track:");
    }

    @Override
    public void processSong(MPDSong song, String line) {
        if (this.startsWith(line)) {
            song.setTrack(this.processTrack(line.substring(this.getPrefix().length()).trim()));
        }
    }

    private int processTrack(String track) {
        try {
            return Integer.parseInt(track.split("/")[0]);
        }
        catch (NumberFormatException nfe) {
            LOGGER.error("Unable to format track", (Throwable)nfe);
            return 0;
        }
    }
}

