/*
 * Decompiled with CFR 0.152.
 */
package org.bff.javampd.objects;

import org.bff.javampd.objects.MPDItem;

public class MPDSong
extends MPDItem {
    private String title;
    private String artistName;
    private String albumName;
    private String file;
    private String genre;
    private String comment;
    private String year;
    private String discNumber;
    private int length;
    private int track;
    private int position = -1;
    private int id = -1;

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getArtistName() {
        return this.artistName;
    }

    public void setArtistName(String artistName) {
        this.artistName = artistName;
    }

    public String getAlbumName() {
        return this.albumName;
    }

    public void setAlbumName(String albumName) {
        this.albumName = albumName;
    }

    public String getFile() {
        return this.file;
    }

    public void setFile(String path) {
        this.file = path;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public int getTrack() {
        return this.track;
    }

    public void setTrack(int track) {
        this.track = track;
    }

    public String getGenre() {
        return this.genre != null ? this.genre : "No Genre";
    }

    public void setGenre(String genre) {
        this.genre = genre;
    }

    public String getComment() {
        return this.comment != null ? this.comment : "";
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getYear() {
        return this.year != null ? this.year : "No Year";
    }

    public void setYear(String year) {
        this.year = year;
    }

    @Override
    public String toString() {
        return "File:" + this.getFile() + "\n" + "Title:" + this.getTitle() + "\n" + "Artist:" + this.getArtistName() + "\n" + "Album:" + this.getAlbumName() + "\n" + "Track:" + this.getTrack() + "\n" + "Year:" + this.getYear() + "\n" + "Genre:" + this.getGenre() + "\n" + "Comment:" + this.getComment() + "\n" + "Length:" + this.getLength() + "\n" + "Pos:" + this.getPosition() + "\n" + "SongId:" + this.getId() + "\n";
    }

    public int getPosition() {
        return this.position;
    }

    public int getId() {
        return this.id;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getDiscNumber() {
        return this.discNumber != null ? this.discNumber : "";
    }

    public void setDiscNumber(String discNumber) {
        this.discNumber = discNumber;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        MPDSong song = (MPDSong)object;
        return this.getFile().equals(song.getFile());
    }

    @Override
    public String getName() {
        return this.getTitle();
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + this.getLength();
        hash = 31 * hash + (null == this.getTitle() ? 0 : this.getTitle().hashCode());
        return hash;
    }

    @Override
    public int compareTo(MPDItem item) {
        MPDSong song = (MPDSong)item;
        StringBuilder sb = new StringBuilder();
        sb.append(this.getAlbumName());
        sb.append(this.formatToComparableString(this.getTrack()));
        String thisSong = sb.toString();
        sb = new StringBuilder();
        sb.append(song.getAlbumName());
        sb.append(this.formatToComparableString(song.getTrack()));
        String songToCompare = sb.toString();
        return thisSong.compareTo(songToCompare);
    }

    private String formatToComparableString(int i) {
        return String.format("%1$08d", i);
    }
}

