/*
 * Decompiled with CFR 0.152.
 */
package org.bff.javampd.monitor;

import com.google.inject.Singleton;
import org.bff.javampd.Status;
import org.bff.javampd.events.VolumeChangeDelegate;
import org.bff.javampd.events.VolumeChangeListener;
import org.bff.javampd.exception.MPDException;
import org.bff.javampd.monitor.VolumeMonitor;

@Singleton
public class MPDVolumeMonitor
implements VolumeMonitor {
    private int newVolume;
    private int oldVolume;
    private VolumeChangeDelegate volumeChangeDelegate = new VolumeChangeDelegate();

    @Override
    public void processResponseStatus(String line) {
        if (Status.lookupStatus(line) == Status.VOLUME) {
            this.newVolume = Integer.parseInt(line.substring(Status.VOLUME.getStatusPrefix().length()).trim());
        }
    }

    @Override
    public void checkStatus() throws MPDException {
        if (this.oldVolume != this.newVolume) {
            this.fireVolumeChangeEvent(this.newVolume);
            this.oldVolume = this.newVolume;
        }
    }

    @Override
    public synchronized void addVolumeChangeListener(VolumeChangeListener vcl) {
        this.volumeChangeDelegate.addVolumeChangeListener(vcl);
    }

    @Override
    public synchronized void removeVolumeChangedListener(VolumeChangeListener vcl) {
        this.volumeChangeDelegate.removeVolumeChangedListener(vcl);
    }

    protected synchronized void fireVolumeChangeEvent(int volume) {
        this.volumeChangeDelegate.fireVolumeChangeEvent(this, volume);
    }
}

