/*
 * Decompiled with CFR 0.152.
 */
package org.bff.javampd.monitor;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.bff.javampd.ServerStatus;
import org.bff.javampd.StandAloneMonitor;
import org.bff.javampd.events.ConnectionChangeListener;
import org.bff.javampd.events.MPDErrorListener;
import org.bff.javampd.events.OutputChangeListener;
import org.bff.javampd.events.PlayerBasicChangeEvent;
import org.bff.javampd.events.PlayerBasicChangeListener;
import org.bff.javampd.events.PlaylistBasicChangeListener;
import org.bff.javampd.events.TrackPositionChangeListener;
import org.bff.javampd.events.VolumeChangeListener;
import org.bff.javampd.exception.MPDException;
import org.bff.javampd.monitor.BitrateMonitor;
import org.bff.javampd.monitor.ConnectionMonitor;
import org.bff.javampd.monitor.ErrorMonitor;
import org.bff.javampd.monitor.Monitor;
import org.bff.javampd.monitor.MonitorProperties;
import org.bff.javampd.monitor.OutputMonitor;
import org.bff.javampd.monitor.PlayerMonitor;
import org.bff.javampd.monitor.PlaylistMonitor;
import org.bff.javampd.monitor.StatusMonitor;
import org.bff.javampd.monitor.TrackMonitor;
import org.bff.javampd.monitor.VolumeMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class MPDStandAloneMonitor
implements StandAloneMonitor,
PlayerBasicChangeListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(MPDStandAloneMonitor.class);
    @Inject
    private ServerStatus serverStatus;
    @Inject
    private OutputMonitor outputMonitor;
    @Inject
    private TrackMonitor trackMonitor;
    @Inject
    private ConnectionMonitor connectionMonitor;
    @Inject
    private VolumeMonitor volumeMonitor;
    @Inject
    private PlayerMonitor playerMonitor;
    @Inject
    private BitrateMonitor bitrateMonitor;
    @Inject
    private PlaylistMonitor playlistMonitor;
    @Inject
    private ErrorMonitor errorMonitor;
    @Inject
    private MonitorProperties monitorProperties;
    private List<ThreadedMonitor> monitors = new ArrayList<ThreadedMonitor>();
    private boolean stopped;

    MPDStandAloneMonitor() {
    }

    private void loadMonitors() {
        this.monitors.add(new ThreadedMonitor(this.trackMonitor, this.monitorProperties.getTrackDelay()));
        this.monitors.add(new ThreadedMonitor(this.playerMonitor, this.monitorProperties.getPlayerDelay()));
        this.monitors.add(new ThreadedMonitor(this.errorMonitor, this.monitorProperties.getErrorDelay()));
        this.monitors.add(new ThreadedMonitor(this.playlistMonitor, this.monitorProperties.getPlaylistDelay()));
        this.monitors.add(new ThreadedMonitor(this.connectionMonitor, this.monitorProperties.getConnectionDelay()));
        this.monitors.add(new ThreadedMonitor(this.bitrateMonitor, this.monitorProperties.getBitrateDelay()));
        this.monitors.add(new ThreadedMonitor(this.volumeMonitor, this.monitorProperties.getVolumeDelay()));
        this.monitors.add(new ThreadedMonitor(this.outputMonitor, this.monitorProperties.getOutputDelay()));
    }

    public synchronized void addTrackPositionChangeListener(TrackPositionChangeListener tpcl) {
        this.trackMonitor.addTrackPositionChangeListener(tpcl);
    }

    public synchronized void removeTrackPositionChangeListener(TrackPositionChangeListener tpcl) {
        this.trackMonitor.removeTrackPositionChangeListener(tpcl);
    }

    public synchronized void addConnectionChangeListener(ConnectionChangeListener ccl) {
        this.connectionMonitor.addConnectionChangeListener(ccl);
    }

    public synchronized void removeConnectionChangeListener(ConnectionChangeListener ccl) {
        this.connectionMonitor.removeConnectionChangeListener(ccl);
    }

    @Override
    public synchronized void addPlayerChangeListener(PlayerBasicChangeListener pcl) {
        this.playerMonitor.addPlayerChangeListener(pcl);
    }

    @Override
    public synchronized void removePlayerChangeListener(PlayerBasicChangeListener pcl) {
        this.playerMonitor.removePlayerChangeListener(pcl);
    }

    @Override
    public synchronized void addVolumeChangeListener(VolumeChangeListener vcl) {
        this.volumeMonitor.addVolumeChangeListener(vcl);
    }

    @Override
    public synchronized void removeVolumeChangedListener(VolumeChangeListener vcl) {
        this.volumeMonitor.removeVolumeChangedListener(vcl);
    }

    @Override
    public synchronized void addOutputChangeListener(OutputChangeListener vcl) {
        this.outputMonitor.addOutputChangeListener(vcl);
    }

    @Override
    public synchronized void removeOutputChangedListener(OutputChangeListener vcl) {
        this.outputMonitor.removeOutputChangedListener(vcl);
    }

    @Override
    public synchronized void addPlaylistChangeListener(PlaylistBasicChangeListener pcl) {
        this.playlistMonitor.addPlaylistChangeListener(pcl);
    }

    @Override
    public synchronized void removePlaylistStatusChangedListener(PlaylistBasicChangeListener pcl) {
        this.playlistMonitor.removePlaylistStatusChangedListener(pcl);
    }

    @Override
    public synchronized void addMPDErrorListener(MPDErrorListener el) {
        this.errorMonitor.addMPDErrorListener(el);
    }

    @Override
    public synchronized void removeMPDErrorListener(MPDErrorListener el) {
        this.errorMonitor.removeMPDErrorListener(el);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.loadMonitors();
        this.loadInitialStatus();
        int delay = this.monitorProperties.getMonitorDelay();
        while (!this.isStopped()) {
            try {
                MPDStandAloneMonitor mPDStandAloneMonitor = this;
                synchronized (mPDStandAloneMonitor) {
                    ArrayList<String> response = new ArrayList<String>(this.serverStatus.getStatus());
                    this.processResponse(response);
                    for (ThreadedMonitor monitor : this.monitors) {
                        monitor.checkStatus();
                    }
                }
                TimeUnit.SECONDS.sleep(delay);
            }
            catch (InterruptedException ie) {
                LOGGER.error("Thread interrupted", (Throwable)ie);
                this.setStopped(true);
            }
            catch (MPDException mpdException) {
                LOGGER.error("Error while checking statuses", (Throwable)mpdException);
                boolean retry = true;
                while (retry) {
                    try {
                        TimeUnit.SECONDS.sleep(this.monitorProperties.getExceptionDelay());
                    }
                    catch (InterruptedException ex) {
                        LOGGER.error("StandAloneMonitor interrupted", (Throwable)ex);
                    }
                    try {
                        this.connectionMonitor.checkStatus();
                        retry = !this.connectionMonitor.isConnected();
                    }
                    catch (MPDException e) {
                        LOGGER.error("Error checking connection status.", (Throwable)e);
                    }
                }
            }
        }
    }

    private void loadInitialStatus() {
        try {
            ArrayList<String> response = new ArrayList<String>(this.serverStatus.getStatus());
            this.processResponse(response);
        }
        catch (MPDException ex) {
            LOGGER.error("Problem with initialization", (Throwable)ex);
        }
    }

    @Override
    public void start() {
        this.setStopped(false);
        Executors.newSingleThreadExecutor().execute(this);
    }

    @Override
    public void stop() {
        this.setStopped(true);
    }

    @Override
    public boolean isStopped() {
        return this.stopped;
    }

    private void setStopped(boolean stopped) {
        this.stopped = stopped;
    }

    private void processResponse(List<String> response) {
        for (String line : response) {
            this.processResponseStatus(line);
        }
    }

    private void processResponseStatus(String line) {
        for (ThreadedMonitor monitor : this.monitors) {
            monitor.processResponseLine(line);
        }
    }

    @Override
    public void playerBasicChange(PlayerBasicChangeEvent event) {
        if (event.getStatus() == PlayerBasicChangeEvent.Status.PLAYER_STOPPED) {
            this.processStoppedStatus();
        }
    }

    private void processStoppedStatus() {
        this.trackMonitor.resetElapsedTime();
        this.playlistMonitor.playerStopped();
    }

    private class ThreadedMonitor {
        private Monitor monitor;
        private int delay;
        private int count;

        ThreadedMonitor(Monitor monitor, int delay) {
            this.monitor = monitor;
            this.delay = delay;
        }

        public void checkStatus() throws MPDException {
            if (this.count++ == this.delay) {
                this.count = 0;
                this.monitor.checkStatus();
            }
        }

        public void processResponseLine(String line) {
            if (this.monitor instanceof StatusMonitor) {
                ((StatusMonitor)this.monitor).processResponseStatus(line);
            }
        }
    }
}

