/*
 * Decompiled with CFR 0.152.
 */
package org.bff.javampd.monitor;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.List;
import org.bff.javampd.Status;
import org.bff.javampd.events.PlaylistBasicChangeEvent;
import org.bff.javampd.events.PlaylistBasicChangeListener;
import org.bff.javampd.exception.MPDException;
import org.bff.javampd.monitor.PlayerMonitor;
import org.bff.javampd.monitor.PlayerStatus;
import org.bff.javampd.monitor.PlaylistMonitor;

@Singleton
public class MPDPlaylistMonitor
implements PlaylistMonitor {
    private List<PlaylistBasicChangeListener> playlistListeners = new ArrayList<PlaylistBasicChangeListener>();
    private int newPlaylistVersion;
    private int oldPlaylistVersion;
    private int newPlaylistLength;
    private int oldPlaylistLength;
    private int oldSong;
    private int newSong;
    private int oldSongId;
    private int newSongId;
    @Inject
    private PlayerMonitor playerMonitor;

    @Override
    public synchronized void addPlaylistChangeListener(PlaylistBasicChangeListener pcl) {
        this.playlistListeners.add(pcl);
    }

    @Override
    public synchronized void removePlaylistStatusChangedListener(PlaylistBasicChangeListener pcl) {
        this.playlistListeners.remove(pcl);
    }

    @Override
    public int getSongId() {
        return this.newSongId;
    }

    @Override
    public void playerStopped() {
        if (this.getSongId() == -1) {
            this.firePlaylistChangeEvent(PlaylistBasicChangeEvent.Event.PLAYLIST_ENDED);
        }
    }

    public synchronized void firePlaylistChangeEvent(PlaylistBasicChangeEvent.Event event) {
        PlaylistBasicChangeEvent pce = new PlaylistBasicChangeEvent(this, event);
        for (PlaylistBasicChangeListener pcl : this.playlistListeners) {
            pcl.playlistBasicChange(pce);
        }
    }

    @Override
    public void processResponseStatus(String line) {
        Status status = Status.lookupStatus(line);
        switch (status) {
            case PLAYLIST: {
                this.newPlaylistVersion = Integer.parseInt(line.substring(Status.PLAYLIST.getStatusPrefix().length()).trim());
                break;
            }
            case PLAYLISTLENGTH: {
                this.newPlaylistLength = Integer.parseInt(line.substring(Status.PLAYLISTLENGTH.getStatusPrefix().length()).trim());
                break;
            }
            case CURRENTSONG: {
                this.newSong = Integer.parseInt(line.substring(Status.CURRENTSONG.getStatusPrefix().length()).trim());
                break;
            }
            case CURRENTSONGID: {
                this.newSongId = Integer.parseInt(line.substring(Status.CURRENTSONGID.getStatusPrefix().length()).trim());
                break;
            }
        }
    }

    @Override
    public void checkStatus() throws MPDException {
        if (this.oldPlaylistVersion != this.newPlaylistVersion) {
            this.firePlaylistChangeEvent(PlaylistBasicChangeEvent.Event.PLAYLIST_CHANGED);
            this.oldPlaylistVersion = this.newPlaylistVersion;
        }
        if (this.oldPlaylistLength != this.newPlaylistLength) {
            if (this.oldPlaylistLength < this.newPlaylistLength) {
                this.firePlaylistChangeEvent(PlaylistBasicChangeEvent.Event.SONG_ADDED);
            } else if (this.oldPlaylistLength > this.newPlaylistLength) {
                this.firePlaylistChangeEvent(PlaylistBasicChangeEvent.Event.SONG_DELETED);
            }
            this.oldPlaylistLength = this.newPlaylistLength;
        }
        if (this.playerMonitor.getStatus() == PlayerStatus.STATUS_PLAYING) {
            if (this.oldSong != this.newSong) {
                this.firePlaylistChangeEvent(PlaylistBasicChangeEvent.Event.SONG_CHANGED);
                this.oldSong = this.newSong;
            } else if (this.oldSongId != this.newSongId) {
                this.firePlaylistChangeEvent(PlaylistBasicChangeEvent.Event.SONG_CHANGED);
                this.oldSongId = this.newSongId;
            }
        }
    }
}

