/*
 * Decompiled with CFR 0.152.
 */
package org.bff.javampd.monitor;

import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.List;
import org.bff.javampd.StandAloneMonitor;
import org.bff.javampd.Status;
import org.bff.javampd.events.PlayerBasicChangeEvent;
import org.bff.javampd.events.PlayerBasicChangeListener;
import org.bff.javampd.exception.MPDException;
import org.bff.javampd.monitor.PlayerMonitor;
import org.bff.javampd.monitor.PlayerStatus;

@Singleton
public class MPDPlayerMonitor
implements PlayerMonitor {
    private PlayerStatus status = PlayerStatus.STATUS_STOPPED;
    private List<PlayerBasicChangeListener> playerListeners = new ArrayList<PlayerBasicChangeListener>();
    private String state = "";

    @Override
    public void processResponseStatus(String line) {
        if (Status.lookupStatus(line) == Status.STATE) {
            this.state = line.substring(Status.STATE.getStatusPrefix().length()).trim();
        }
    }

    @Override
    public void checkStatus() throws MPDException {
        PlayerStatus newStatus = PlayerStatus.STATUS_STOPPED;
        if (this.state.startsWith(StandAloneMonitor.PlayerResponse.PLAY.getPrefix())) {
            newStatus = PlayerStatus.STATUS_PLAYING;
        } else if (this.state.startsWith(StandAloneMonitor.PlayerResponse.PAUSE.getPrefix())) {
            newStatus = PlayerStatus.STATUS_PAUSED;
        } else if (this.state.startsWith(StandAloneMonitor.PlayerResponse.STOP.getPrefix())) {
            newStatus = PlayerStatus.STATUS_STOPPED;
        }
        if (!this.status.equals((Object)newStatus)) {
            switch (newStatus) {
                case STATUS_PLAYING: {
                    this.processPlayingStatus(this.status);
                    break;
                }
                case STATUS_STOPPED: {
                    this.firePlayerChangeEvent(PlayerBasicChangeEvent.Status.PLAYER_STOPPED);
                    break;
                }
                case STATUS_PAUSED: {
                    this.processPausedStatus(this.status);
                    break;
                }
                default: {
                    assert (false) : "Invalid player status --> " + (Object)((Object)this.status);
                    break;
                }
            }
            this.status = newStatus;
        }
    }

    @Override
    public synchronized void addPlayerChangeListener(PlayerBasicChangeListener pcl) {
        this.playerListeners.add(pcl);
    }

    @Override
    public synchronized void removePlayerChangeListener(PlayerBasicChangeListener pcl) {
        this.playerListeners.remove(pcl);
    }

    @Override
    public PlayerStatus getStatus() {
        return this.status;
    }

    protected synchronized void firePlayerChangeEvent(PlayerBasicChangeEvent.Status status) {
        PlayerBasicChangeEvent pce = new PlayerBasicChangeEvent(this, status);
        for (PlayerBasicChangeListener pcl : this.playerListeners) {
            pcl.playerBasicChange(pce);
        }
    }

    private void processPlayingStatus(PlayerStatus status) {
        switch (status) {
            case STATUS_PAUSED: {
                this.firePlayerChangeEvent(PlayerBasicChangeEvent.Status.PLAYER_UNPAUSED);
                break;
            }
            case STATUS_STOPPED: {
                this.firePlayerChangeEvent(PlayerBasicChangeEvent.Status.PLAYER_STARTED);
                break;
            }
            default: {
                assert (false) : "Invalid player status --> " + (Object)((Object)status);
                break;
            }
        }
    }

    private void processPausedStatus(PlayerStatus status) {
        switch (status) {
            case STATUS_PAUSED: {
                this.firePlayerChangeEvent(PlayerBasicChangeEvent.Status.PLAYER_UNPAUSED);
                break;
            }
            case STATUS_PLAYING: {
                this.firePlayerChangeEvent(PlayerBasicChangeEvent.Status.PLAYER_PAUSED);
                break;
            }
            case STATUS_STOPPED: {
                this.firePlayerChangeEvent(PlayerBasicChangeEvent.Status.PLAYER_STOPPED);
                break;
            }
            default: {
                assert (false) : "Invalid player status --> " + (Object)((Object)status);
                break;
            }
        }
    }
}

