/*
 * Decompiled with CFR 0.152.
 */
package org.bff.javampd.monitor;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bff.javampd.Admin;
import org.bff.javampd.MPDOutput;
import org.bff.javampd.events.OutputChangeEvent;
import org.bff.javampd.events.OutputChangeListener;
import org.bff.javampd.exception.MPDAdminException;
import org.bff.javampd.monitor.OutputMonitor;

@Singleton
public class MPDOutputMonitor
implements OutputMonitor {
    private Map<Integer, MPDOutput> outputMap = new HashMap<Integer, MPDOutput>();
    private List<OutputChangeListener> outputListeners = new ArrayList<OutputChangeListener>();
    @Inject
    private Admin admin;

    @Override
    public void checkStatus() throws MPDAdminException {
        ArrayList<MPDOutput> outputs = new ArrayList<MPDOutput>(this.admin.getOutputs());
        if (outputs.size() > this.outputMap.size()) {
            this.fireOutputChangeEvent(new OutputChangeEvent(this, OutputChangeEvent.OUTPUT_EVENT.OUTPUT_ADDED));
            this.loadOutputs(outputs);
        } else if (outputs.size() < this.outputMap.size()) {
            this.fireOutputChangeEvent(new OutputChangeEvent(this, OutputChangeEvent.OUTPUT_EVENT.OUTPUT_DELETED));
            this.loadOutputs(outputs);
        } else {
            for (MPDOutput out : outputs) {
                MPDOutput output = this.outputMap.get(out.getId());
                if (output == null) {
                    this.fireOutputChangeEvent(new OutputChangeEvent(out, OutputChangeEvent.OUTPUT_EVENT.OUTPUT_CHANGED));
                    this.loadOutputs(outputs);
                    return;
                }
                if (output.isEnabled() == out.isEnabled()) continue;
                this.fireOutputChangeEvent(new OutputChangeEvent(out, OutputChangeEvent.OUTPUT_EVENT.OUTPUT_CHANGED));
                this.loadOutputs(outputs);
                return;
            }
        }
    }

    @Override
    public synchronized void addOutputChangeListener(OutputChangeListener vcl) {
        this.outputListeners.add(vcl);
    }

    @Override
    public synchronized void removeOutputChangedListener(OutputChangeListener vcl) {
        this.outputListeners.remove(vcl);
    }

    protected synchronized void fireOutputChangeEvent(OutputChangeEvent event) {
        for (OutputChangeListener ocl : this.outputListeners) {
            ocl.outputChanged(event);
        }
    }

    private void loadOutputs(Collection<MPDOutput> outputs) {
        this.outputMap.clear();
        for (MPDOutput output : outputs) {
            this.outputMap.put(output.getId(), output);
        }
    }
}

