/*
 * Decompiled with CFR 0.152.
 */
package org.bff.javampd.monitor;

import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.List;
import org.bff.javampd.Status;
import org.bff.javampd.events.MPDErrorEvent;
import org.bff.javampd.events.MPDErrorListener;
import org.bff.javampd.exception.MPDException;
import org.bff.javampd.monitor.ErrorMonitor;

@Singleton
public class MPDErrorMonitor
implements ErrorMonitor {
    private String error;
    private List<MPDErrorListener> errorListeners = new ArrayList<MPDErrorListener>();

    @Override
    public synchronized void addMPDErrorListener(MPDErrorListener el) {
        this.errorListeners.add(el);
    }

    @Override
    public synchronized void removeMPDErrorListener(MPDErrorListener el) {
        this.errorListeners.remove(el);
    }

    protected void fireMPDErrorEvent(String msg) {
        MPDErrorEvent ee = new MPDErrorEvent(this, msg);
        for (MPDErrorListener el : this.errorListeners) {
            el.errorEventReceived(ee);
        }
    }

    @Override
    public void processResponseStatus(String line) {
        Status status = Status.lookupStatus(line);
        if (status == Status.ERROR) {
            this.error = line.substring(Status.ERROR.getStatusPrefix().length()).trim();
        }
    }

    @Override
    public void checkStatus() throws MPDException {
        if (this.error != null) {
            this.fireMPDErrorEvent(this.error);
            this.error = null;
        }
    }
}

